import { defineStore } from 'pinia'
import { getUser, logout, getBuyShop } from '@/api/base'

import type { UserState } from '@/types'
interface State {
  user: UserState | null
  courses: any
}
export const useUserStore = defineStore({
  id: 'user',
  state: (): State => ({
    user: null,
    courses: []
  }),
  getters: {
    isLogin: state => !!state.user,
    userName: ({ user }) => {
      if (!user) return ''
      return user.realname || user.nickname || user.username || ''
    },
    mobile: ({ user }) => {
      if (!user) return ''
      return user.mobile
    }
  },
  actions: {
    async getUser() {
      const res = await getUser()
      try {
        await this.getCourse()
      } catch (error) {
        console.log(error)
      }
      this.user = res.data
    },

    async logout() {
      await logout()
      this.user = null
    },

    async getCourse() {
      this.courses = await getBuyShop()
    }
  }
})
