import cAction from '@action'

import { Message } from 'element-ui'

export default class Before {
  constructor (opt) {
    this.opt = opt || {}
  }

  async update (to, from, next) {
    if (to.name === 'studentHelp' || to.name === 'teacherHelp') {
      next()
    } else if (to.name !== 'login-normal' && to.name !== 'codeLogin' && to.name !== 'forgetPwd') { // 所有登录页 不进行登录校验
      const isLogin = await this.isLogin()
      if (isLogin) {
        next()
      } else {
        next({ path: '/login/index?rd=' + encodeURIComponent(to.fullPath) }) // 需要传参并再传回来
      }
    }
  }

  /* 获取用户信息 */
  isLogin () {
    if (window.G.UserInfo) return true
    return cAction.Test.getInfo().then(res => {
      window.G.UserInfo = res
      return true
    }).catch(res => {
      Message({ type: 'error', message: res.message })
      return false
    })
  }
}
