import Layout from '@/components/layout'

export default [
  { path: '*', redirect: '/' },
  {
    path: '/',
    component: Layout,
    children: [
      { path: '', redirect: '/index' },
      { path: '/index', component: () => import('@/pages/home/index.vue') },
      {
        path: '/project', // 项目介绍
        component: () => import('@/pages/project/index.vue')
      },
      {
        path: '/recruit', // 招生信息
        component: () => import('@/pages/recruitInfo/index.vue')
      },
      {
        path: '/presence', // 师生风采
        component: () => import('@/pages/presence/index.vue')
      },
      {
        path: '/alumniWork', // 校友工作
        component: () => import('@/pages/alumniWork/index.vue')
      },
      {
        path: '/teaching', // 教学模块
        component: () => import('@/pages/teaching/index.vue')
      },
      {
        path: '/videoCenter', // 视频中心
        component: () => import('@/pages/videoCenter/index.vue')
      }
    ]
  },
  {
    path: '/showcase',
    component: Layout,
    props: { hasFooter: false },
    children: [{ path: '', component: () => import('@/pages/showcase/index.vue') }]
  },
  {
    path: '/personal',
    component: Layout,
    props: { hasFooter: false },
    children: [{ path: '', component: () => import('@/pages/personal/index.vue'), meta: { requiredLogin: true } }]
  },
  {
    path: '/cert',
    redirect: { path: '/personal', query: { index: 1 } }
  },
  {
    path: '/card',
    redirect: { path: '/personal', query: { index: 2 } }
  },
  // 在线报名
  {
    path: '/my',
    component: Layout,
    props: { hasFooter: false },
    children: [
      {
        name: 'apply',
        path: '',
        component: () => import(/* webpackChunkName: "my-welcome" */ '@/pages/my/welcome/index.vue'),
        meta: { requiredLogin: true }
      },
      {
        name: 'account',
        path: 'account',
        component: () => import(/* webpackChunkName: "my-account" */ '@/pages/my/account/index.vue'),
        meta: { requiredLogin: true }
      },
      {
        path: 'application',
        component: () => import(/* webpackChunkName: "my-application" */ '@/pages/my/application/index.vue'),
        meta: { requiredLogin: true }
      },
      {
        path: 'interview',
        component: () => import(/* webpackChunkName: "my-interview" */ '@/pages/my/interview/index.vue'),
        meta: { requiredLogin: true }
      },
      {
        path: 'admission',
        component: () => import(/* webpackChunkName: "my-admission" */ '@/pages/my/admission/index.vue'),
        meta: { requiredLogin: true }
      }
    ]
  },
  // 推荐信
  {
    path: '/letter',
    component: () => import(/* webpackChunkName: "letter" */ '@/pages/letter/index.vue')
  },
  {
    path: '/application-materials/reco-letters/submit/:projectId/:userId/:letterId',
    component: () => import(/* webpackChunkName: "letter" */ '@/pages/letter/index.vue')
  },
  {
    path: '/preview',
    props: { isManager: true },
    component: () => import(/* webpackChunkName: "preview" */ '@/pages/my/application/preview.vue')
  },
  {
    path: '/complete',
    component: () => import(/* webpackChunkName: "complete" */ '@/pages/my/application/complete.vue')
  }
]
