import BaseAPI from '@/api/base_api'

const httpRequest = new BaseAPI(webConf)

/**
 * 获取用户信息
 */
export function getUser() {
  return httpRequest.get('/passport/account/get-user-info')
}

/**
 * 修改用户信息
 */
export function updateUser(data) {
  return httpRequest.post('/usercenter/user/update-user', data)
}

/**
 * 修改密码
 */
export function updatePassword(data) {
  return httpRequest.post('/usercenter/user/update-pwd', data)
}

/**
 * 发送验证码
 */
export function sendCode(data) {
  return httpRequest.post('/usercenter/user/send-code', data)
}
/**
 * 检验验证码
 */
export function checkCode(params) {
  return httpRequest.get('/usercenter/user/check-code' + params)
}
/**
 * 获取报名信息
 */
export function getApplication(params) {
  return httpRequest.get(`/enrollment/v1.0/application-materials/${window.PROJECT_ID}`, params)
}
/**
 * 获取报名信息
 */
export function updateApplication(data) {
  return httpRequest.post(`/enrollment/v1.0/application-materials/${window.PROJECT_ID}/put`, data, {
    headers: { 'Content-Type': 'application/json' }
  })
}

/**
 * 获取报名审核状态
 */
export function getApplicationStatus() {
  return httpRequest.get(`/enrollment/v1.0/application-materials/profile/${window.PROJECT_ID}`)
}

/**
 * 获取支付二维码
 */
export function getOrder(params) {
  return httpRequest.get(
    `/enrollment/v1.0/application-materials/payment-records/request/${window.PROJECT_ID}/APPLICATION_FEE`,
    params
  )
}

/**
 * 检查支付状态
 */
export function checkPay(id, params) {
  return httpRequest.get(
    `/enrollment/v1.0/application-materials/payment-records/check-status/${window.PROJECT_ID}/APPLICATION_FEE/${id}`,
    params
  )
}

/**
 * 写推荐信
 */
export function addLetter(userId, letterId, data) {
  return httpRequest.post(
    `/enrollment/v1.0/application-materials/reco-letters/submit/${window.PROJECT_ID}/${userId}/${letterId}/put`,
    data,
    {
      headers: { 'Content-Type': 'application/json' }
    }
  )
}

/**
 * 更换推荐人
 */
export function updateProvider(letterId, data) {
  return httpRequest.post(
    `/enrollment/v1.0/application-materials/reco-letters/change-provider/${window.PROJECT_ID}/${letterId}/put`,
    data,
    {
      headers: { 'Content-Type': 'application/json' }
    }
  )
}
/**
 * 再次邀请
 */
export function sendToProvider(letterId) {
  return httpRequest.get(
    `/enrollment/v1.0/application-materials/reco-letters/send-invitation-to-provider/${window.PROJECT_ID}/${letterId}`
  )
}

/**
 * 发送推荐信
 */
export function sendToProviders() {
  return httpRequest.get(
    `/enrollment/v1.0/application-materials/reco-letters/send-invitation-to-providers/${window.PROJECT_ID}`
  )
}
/**
 * 退出登录
 */
export function logout() {
  return httpRequest.get('/passport/rest/logout')
}

/**
 * 更改附件状态
 */
export function changeFileStatus(userId, recordId, status) {
  return httpRequest.get(
    `/enrollment/v1.0/application-materials/attachments/change-status/${window.PROJECT_ID}/${userId}/${recordId}`,
    { status }
  )
}

/**
 * 修改用户信息
 */
export function getOpenId(data) {
  return httpRequest.post('/usercenter/v1/wechat/get-openid', data)
}

/**
 * 签名
 */
export function createSign(data) {
  return httpRequest.post('/usercenter/v1/sign/sign', data)
}

/**
 * 获取签名文档
 */
export function getSignDocument(params) {
  return httpRequest.get('/usercenter/v1/sign/document', params)
}
