export default {
  id: 'admission_ywjl',
  title: '英文简历',
  get: {
    action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/${window.PROJECT_ID}`,
    callback(data) {
      const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
      const stageList = [
        'FILLING',
        'PREPAYMENT',
        'INTERVIEW_APPLICATION',
        'AUDITION',
        'INTERVIEW',
        'PAYMENT',
        'REGISTRATION',
        'CLOSED'
      ]
      this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 6
      const RESUME_EN = attachments.filter(item => {
        return item.file_type_id === 'RESUME_EN'
      })
      return { RESUME_EN }
    }
  },
  form: {
    prev: { to: { query: { active: 'admission_tjx' } } },
    next: { to: { query: { active: 'admission_zp' } } },
    hasButton: false,
    options: {},
    items: [
      {
        type: 'v-upload',
        required: true,
        model: 'RESUME_EN',
        attrs: {
          action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${window.PROJECT_ID}/put`,
          deleteAction: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${window.PROJECT_ID}/delete`,
          data: { file_type: 'RESUME_EN' },
          limit: 1
        },
        append: `
        <p>请下载填写英文简历模板后上传 [<a href="https://webapp-pub.ezijing.com/project/marywood/marywood%E8%8B%B1%E6%96%87%E7%AE%80%E5%8E%86%E6%A8%A1%E6%9D%BF.doc" target="_blank" download="英文简历模板" style="color:blue">下载模板</a>]</p>
        <p>请将英文简历填写完存为"word"格式上传，文件小于10MB。</p>`
      }
    ]
  }
}
