import BaseAPI from './base_api'

export default class TestAPI extends BaseAPI {
  /**
   * get传输方式
   * @param {[string]} id resource_id
   */
  getTest = (id) => this.get(`/vue-client/get/${id}`, {})
  /**
   * post传输方式
   * @param {[object]} obj
   */
  postTest = (obj = {}) => this.post('/passport/rest/login', obj, { headers: { 'Content-Type': 'multipart/form-data' } })
  /**
  * 当前登录用户，检测是否该系统有权限
  */
 getInfo = () => this.get('/passport/account/get-user-info', {}, { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } })
}
