import httpRequest from '@/utils/httpRequest'

// 获取文章分类
export function getAllClassify(params) {
  return httpRequest.get('/api/microservices/api/category/articles', { params })
}
// 获取文章
export function getArticle(params) {
  return httpRequest.get('/api/microservices/api/article/list', { params })
}
// 获取文章详情
export function getArticleDetail(id) {
  return httpRequest.get(`/api/microservices/api/article/${id}/info`)
}
// 获取轮播
export function getBanner(params) {
  return httpRequest.get('/api/microservices/api/carousel/list', { params })
}
// 发送验证码
export function sendCode(data) {
  return httpRequest.post('/api/usercenter/user/send-code', data)
}
// 注册
export function register(data) {
  return httpRequest.post('/api/usercenter/user/register', data)
}
// 注册并登录
export function registerAndLogin(data) {
  return httpRequest.post('/api/usercenter/user/register-and-login-by-mobile', data)
}
// 获取用户信息
export function getUser() {
  return httpRequest.get('/api/passport/account/get-user-info')
}
// 提交报名信息
export function submitForm(data) {
  return httpRequest.post('/api/microservices/api/v3/apply/student-form', data)
}
// 获取报名信息
export function getFormDetail(params) {
  return httpRequest.get('/api/microservices/api/v3/apply/student-form-detail', { params })
}
// 创建订单
export function createOrder(data) {
  return httpRequest.post('/api/microservices/api/v3/apply/student-unified-order', data)
}
// 查看订单状态
export function checkPay(id) {
  return httpRequest.post('/api/pay/order/query', { order_id: id }, { headers: { 'Content-Type': 'application/json' } })
}
// 支付完成通知
export function payEnd(data) {
  return httpRequest.post('/api/microservices/api/v3/apply/student-pay-end', data)
}
// 更新用户信息
export function updateUser(data) {
  return httpRequest.post('/api/usercenter/user/update-user', data)
}
// 获取证书
export function getCertCard(params) {
  return httpRequest.get('/api/cert/api/v1/cert/detail', { params })
}
// 提交留咨信息
export function submitApplicationForm(data) {
  return httpRequest.post('/api/enrollment/v1.0/applications', data)
}
