import Vue from 'vue'
import VueRouter from 'vue-router'
import Layout from '@/components/layout/index.vue'

Vue.use(VueRouter)

const routes = [
  { path: '*', redirect: '/index' },
  {
    path: '/',
    component: Layout,
    children: [
      { path: '', redirect: '/index' },
      { path: '/index', component: () => import('@/pages/home/index.vue') },
      // 工作动态
      { path: '/news', component: () => import('@/pages/news/index.vue') },
      { path: '/news/detail', component: () => import('@/pages/news/detail.vue') },
      // 1+x产品
      { path: '/product', component: () => import('@/pages/product/index.vue') },
      // 证书成绩查询
      { path: '/attestation', redirect: '/attestation/teacher' },
      { path: '/attestation/teacher', component: () => import('@/pages/attestation/teacher.vue') },
      { path: '/attestation/teacher/query', component: () => import('@/pages/attestation/teacherQuery.vue') },
      { path: '/attestation/student', component: () => import('@/pages/attestation/student.vue') },
      { path: '/attestation/student/query', component: () => import('@/pages/attestation/studentQuery.vue') },
      // 技能培训
      { path: '/train', component: () => import('@/pages/train/index.vue') },
      // 技能培训详情
      { path: '/train/list', component: () => import('@/pages/train/list.vue') },
      { path: '/train/detail', component: () => import('@/pages/train/detail.vue') },
      { path: '/train/form', component: () => import('@/pages/train/form.vue') },
    ],
  },
]

const router = new VueRouter({
  mode: 'history',
  routes,
  scrollBehavior() {
    return { x: 0, y: 0 }
  },
})

export default router
