export default function(_this) {
  return {
    id: 'interview_zp',
    title: '2寸照片',
    get: {
      action: `/api/enrollment/v1.0/application-materials/${webConf.others.projectId}`,
      callback(data) {
        const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        const stageList = [
          'FILLING',
          'PREPAYMENT',
          'INTERVIEW_APPLICATION',
          'AUDITION',
          'INTERVIEW',
          'PAYMENT',
          'REGISTRATION',
          'CLOSED'
        ]
        this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 2
        const PERSONAL_PHOTO_FOR_ID = attachments.filter(item => {
          return item.file_type_id === 'PERSONAL_PHOTO_FOR_ID'
        })
        return { PERSONAL_PHOTO_FOR_ID }
      }
    },
    form: {
      next: { to: { query: { active: 'interview_byzs' } } },
      hasButton: false,
      options: {},
      items: [
        {
          type: 'v-upload',
          model: 'PERSONAL_PHOTO_FOR_ID',
          attrs: {
            action: `/api/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/put`,
            deleteAction: `/api/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/delete`,
            data: { file_type: 'PERSONAL_PHOTO_FOR_ID' },
            limit: 1
          },
          append:
            '申请者需要上传本人半年以内的一寸彩色近照。<br> 只需上传一个文件，且照片完整、干净。<br> 上传文件仅限“jpg,jpeg,gif,png”格式的图片文件，且文件小于10MB。'
        }
      ]
    }
  }
}
