import Vue from 'vue' // 引入vue框架
import router from './router'
import VueForm from '@ezijing/vue-form'
import '@ezijing/vue-form/dist/vue-form.css'
import App from './app.vue' // 初始化 vue页面
import './style.scss' // 公共样式
import MetaInfo from 'vue-meta-info'
import Element from 'element-ui'
import createBefore from './components/beforeEnter'
import store from './store'
import './assets/css/reset.css'
import './assets/css/animate.min.css'
import VueLazyComponent from '@xunlei/vue-lazy-component'

Vue.use(VueForm)

Vue.use(VueLazyComponent)

Vue.use(MetaInfo)
Vue.use(Element)

/* 设置全局变量 */
window.G = Vue.prototype.$GLOBAL = {
  VERSION: 'PC-1.0.0'
}
/**
 * 定义全局变量 - 用作全局事件发布订阅
 * 使用 vue自带事件 $emit 和 $on 进行发布订阅
 */
Vue.prototype.VueEvent = new Vue()

/* 创建实例之前，通过导航守卫，处理部分逻辑，如：是否直接进入系统 */
const before = createBefore()
/* 导航守卫 */
router.beforeEach(async (to, from, next) => {
  await store.dispatch('generateRoutes')
  before.update(to, from, next)
})

window.G.$instance_vue = new Vue({
  router,
  store,
  render: h => h(App)
}).$mount('#app')
