/**
 * 学习目的
 */

export default function(_this) {
  return {
    id: 'application_info_answer',
    title: '学习目的',
    required: true,
    visible() {
      return _this.visible
    },
    get: {
      action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/${webConf.others.projectId}`,
      callback(data) {
        const { answers = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        this.form.options.disabled = submissionStage !== 'FILLING'

        const [first = {}, second = {}, third = {}, fourth = {}] = answers
        return {
          qid1: first.qid || '1',
          question1: '自我介绍',
          answer1: first.answer,
          qid2: second.qid || '2',
          question2: '申请这个家庭教育硕士项目在未来对你个人有什么好处?',
          answer2: second.answer,
          qid3: third.qid || '3',
          question3: '通过这个家庭教育硕士项目的学习，你对自己未来的个人发展目标/职业发展目标是什么? ',
          answer3: third.answer,
          qid4: fourth.qid || '4',
          question4:
            '你参加过家庭教育或者与之相关的工作坊或者培训吗？请按照年份列出来，你是如何从这些学习经验中获益的？',
          answer4: fourth.answer
        }
      }
    },
    update: {
      action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/${webConf.others.projectId}/put`,
      beforeRequest(data) {
        return {
          answers: [
            { qid: data.qid1, question: data.question1, answer: data.answer1 },
            { qid: data.qid2, question: data.question2, answer: data.answer2 },
            { qid: data.qid3, question: data.question3, answer: data.answer3 },
            { qid: data.qid4, question: data.question4, answer: data.answer4 }
          ]
        }
      }
    },
    form: {
      prev: { to: { query: { active: 'application_info', tab: 'application_info_career' } }, isSubmit: true },
      next: { to: { query: { active: 'application_info', tab: 'application_info_training' } }, isSubmit: true },
      options: { 'label-position': 'top' },
      items: [
        {
          type: 'v-input',
          label:
            '自我介绍(简要介绍一下自己，你是如何对家庭教育产生的兴趣，什么促使你下定决心学习家庭教育；可以讲一个跟自身有关的故事。)不低于300字',
          model: 'answer1',
          attrs: { type: 'textarea', rows: '8', style: 'width:100%' },
          rules: [
            { required: true, message: '请输入', trigger: 'blur' },
            { min: 300, message: '长度在 300 个字符以上', trigger: 'blur' }
          ]
        },
        {
          type: 'v-input',
          label: '申请这个家庭教育硕士项目在未来对你个人有什么好处? 不低于260字',
          model: 'answer2',
          attrs: { type: 'textarea', rows: '8', style: 'width:100%' },
          rules: [
            { required: true, message: '请输入', trigger: 'blur' },
            { min: 260, message: '长度在 260 个字符以上', trigger: 'blur' }
            // { min: 60, max: 1000, message: '长度在 60 到 1000 个字符', trigger: 'blur' }
          ]
        },
        {
          type: 'v-input',
          label: '通过这个家庭教育硕士项目的学习，你对自己未来的个人发展目标/职业发展目标是什么? 不低于260字。',
          model: 'answer3',
          attrs: { type: 'textarea', rows: '8', style: 'width:100%' },
          rules: [
            { required: true, message: '请输入', trigger: 'blur' },
            { min: 260, message: '长度在 260 个字符以上', trigger: 'blur' }
            // { min: 60, max: 1000, message: '长度在 60 到 1000 个字符', trigger: 'blur' }
          ]
        },
        {
          type: 'v-input',
          label: '你参加过家庭教育或者与之相关的工作坊或者培训吗？请按照年份列出来，你是如何从这些学习经验中获益的？',
          model: 'answer4',
          attrs: { type: 'textarea', rows: '8', style: 'width:100%' },
          rules: [
            { required: true, message: '请输入', trigger: 'blur' }
            // { min: 260, message: '长度在 260 个字符以上', trigger: 'blur' }
            // { min: 60, max: 1000, message: '长度在 60 到 1000 个字符', trigger: 'blur' }
          ]
        }
      ]
    }
  }
}
