export default function(_this) {
  return {
    id: 'admission_xlrz',
    title: '学历认证备案表',
    get: {
      action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/${webConf.others.projectId}`,
      callback(data) {
        const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        const stageList = [
          'FILLING',
          'PREPAYMENT',
          'INTERVIEW_APPLICATION',
          'AUDITION',
          'INTERVIEW',
          'PAYMENT',
          'REGISTRATION',
          'CLOSED'
        ]
        this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 6
        const ACADEMIC_CERTIFICATE_TABLE = attachments.filter(item => {
          return item.file_type_id === 'ACADEMIC_CERTIFICATE_TABLE'
        })
        return { ACADEMIC_CERTIFICATE_TABLE }
      }
    },
    form: {
      prev: { to: { query: { active: 'admission_xfjn' } } },
      hasButton: false,
      options: { 'label-position': 'top' },
      hint: `
        <p>请上传《教育部学历证书电子注册备案表》英文版</p>
        <p>申请途径：学信网 <a href="https://www.chsi.com.cn" target="_blank" style="color:blue">https://www.chsi.com.cn</a></p>`,
      items: [
        {
          type: 'v-upload',
          model: 'ACADEMIC_CERTIFICATE_TABLE',
          attrs: {
            action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/put`,
            deleteAction: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/delete`,
            data: { file_type: 'ACADEMIC_CERTIFICATE_TABLE' }
          },
          prepend: `
            <div><a href="https://webapp-pub.ezijing.com/project/marywood/xlzm.png" target="_blank"><img src="https://webapp-pub.ezijing.com/project/marywood/xlzm.png" width="174px" /></a></div>
            <div style="width:174px;text-align:center;margin-bottom:20px;">英文样本</div>
          `
        }
      ]
    }
  }
}
