export default function(_this) {
  return {
    id: 'interview_byzs',
    title: '毕业证书',
    get: {
      action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/${webConf.others.projectId}`,
      callback(data) {
        const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        const stageList = [
          'FILLING',
          'PREPAYMENT',
          'INTERVIEW_APPLICATION',
          'AUDITION',
          'INTERVIEW',
          'PAYMENT',
          'REGISTRATION',
          'CLOSED'
        ]
        this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 2
        const DIPLOMA_CN = attachments.filter(item => {
          return item.file_type_id === 'DIPLOMA_CN'
        })
        return { DIPLOMA_CN }
      }
    },
    update: {
      action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/submit/${webConf.others.projectId}`,
      beforeRequest(data) {
        return { submission_stage: 'INTERVIEW_APPLICATION' }
      },
      callback() {
        this.form.options.disabled = true
        _this.dialogVisible = true
        _this.getApplication()
      },
      errorCallback() {
        _this.completeVisible = true
      }
    },
    form: {
      next: { to: { query: { active: 'interview_tjx' } } },
      hasButton: false,
      // submitText: '申请面试',
      model: { submission_stage: 'INTERVIEW_APPLICATION' },
      options: {},
      items: [
        {
          type: 'v-upload',
          required: true,
          model: 'DIPLOMA_CN',
          attrs: {
            action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/put`,
            deleteAction: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/delete`,
            data: { file_type: 'DIPLOMA_CN' }
          },
          append:
            '申请者需要将本科或以上毕业证书原件扫描或者拍照后提交。<br> 可上传多个文件，请确保证书号码清晰可辨。<br> 上传文件仅限“jpg,jpeg,png”格式，文件小于10MB。'
        }
      ]
    }
  }
}
