export default {
  id: 'interview_ywjl',
  title: '英文简历',
  get: {
    action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/${webConf.others.projectId}`,
    callback(data) {
      const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
      const stageList = [
        'FILLING',
        'PREPAYMENT',
        'INTERVIEW_APPLICATION',
        'AUDITION',
        'INTERVIEW',
        'PAYMENT',
        'REGISTRATION',
        'CLOSED'
      ]
      this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 2
      const RESUME_EN = attachments.filter(item => {
        return item.file_type_id === 'RESUME_EN'
      })
      return { RESUME_EN }
    }
  },
  form: {
    prev: { to: { query: { active: 'interview_xwzs' } } },
    next: { to: { query: { active: 'interview_zp' } } },
    hasButton: false,
    options: {},
    items: [
      {
        type: 'v-upload',
        required: true,
        model: 'RESUME_EN',
        attrs: {
          action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/put`,
          deleteAction: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/delete`,
          data: { file_type: 'RESUME_EN' }
        },
        append: `
        <p>请下载填写英文简历模板后上传 [<a href="https://zws-imgs-pub.ezijing.com/static/public/2e8e4f6898f59e03636139a402ef16c1.docx" target="_blank" download="英文简历模板">下载模板</a>]</p>
        <p>请将英文简历填写完存为"pdf"格式上传，文件小于10MB。</p>`
      }
    ]
  }
}
