/**
 * 工作经验
 */

export default function(_this) {
  return {
    id: 'application_info_career',
    title: '工作经验',
    required: true,
    visible() {
      return _this.visible
    },
    get: {
      action: `/api/enrollment/v1.0/application-materials/${webConf.others.projectId}`,
      callback(data) {
        const { careers: list = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        this.form.options.disabled = submissionStage !== 'FILLING'
        return list.length ? list : [{}]
      }
    },
    update: {
      action: `/api/enrollment/v1.0/application-materials/${webConf.others.projectId}/put`,
      beforeRequest(data) {
        const careers = data.map(item => {
          return [
            'start_date',
            'end_date',
            'company_name_cn',
            'industry',
            'dept_cn',
            'position_cn',
            'job_desc_cn'
          ].reduce((result, key) => {
            result[key] = item[key]
            return result
          }, {})
        })
        return { careers }
      }
    },
    form: {
      prev: { to: { query: { active: 'application_info', tab: 'application_info_education' } }, isSubmit: true },
      next: { to: { query: { active: 'application_info', tab: 'application_info_answer' } }, isSubmit: true },
      hasAdd: true,
      options: { labelWidth: '140px' },
      items: [
        {
          type: 'v-datepicker',
          label: '开始时间',
          model: 'start_date',
          attrs: {
            type: 'month',
            placeholder: '请选择工作开始时间',
            valueFormat: 'yyyy-MM'
          },
          rules: [{ required: true, message: '请选择工作开始时间', trigger: 'blur' }]
        },
        {
          type: 'v-datepicker',
          label: '结束时间',
          model: 'end_date',
          attrs: {
            type: 'month',
            placeholder: '请选择工作结束时间',
            valueFormat: 'yyyy-MM'
          },
          rules: [{ required: true, message: '请选择工作结束时间', trigger: 'blur' }]
        },
        {
          type: 'v-input',
          label: '工作单位',
          model: 'company_name_cn',
          attrs: { placeholder: '请输入工作单位' },
          rules: [{ required: true, message: '请输入工作单位', trigger: 'blur' }]
        },
        {
          type: 'v-select',
          values: [
            { label: '互联网/电子商务', value: '1 ' },
            { label: '基金/证券/期货/投资', value: '2 ' },
            { label: '保险', value: '3 ' },
            { label: '银行', value: '4 ' },
            { label: '信托/担保/拍卖/典当', value: '5 ' },
            { label: '计算机软件', value: '6 ' },
            { label: 'IT服务(系统/数据/维护)', value: '7 ' },
            { label: '电子技术/半导体/集成电路', value: '8 ' },
            { label: '计算机硬件', value: '9 ' },
            { label: '通信/电信/网络设备', value: '10' },
            { label: '通信/电信运营、增值服务', value: '11' },
            { label: '网络游戏', value: '12' },
            { label: '房地产/建筑/建材/工程', value: '13' },
            { label: '家居/室内设计/装饰装潢', value: '14' },
            { label: '物业管理/商业中心', value: '15' },
            { label: '专业服务/咨询(财会/法律/人力资源等)', value: '16' },
            { label: '广告/会展/公关', value: '17' },
            { label: '中介服务', value: '18' },
            { label: '检验/检测/认证', value: '19' },
            { label: '外包服务', value: '20' },
            { label: '快速消费品（食品/饮料/烟酒/日化）', value: '21' },
            { label: '耐用消费品（服饰/纺织/皮革/家具/家电）', value: '22' },
            { label: '贸易/进出口', value: '23' },
            { label: '零售/批发', value: '24' },
            { label: '租赁服务', value: '25' },
            { label: '教育/培训/院校', value: '26' },
            { label: '礼品/玩具/工艺美术/收藏品/奢侈品', value: '27' },
            { label: '汽车/摩托车', value: '28' },
            { label: '大型设备/机电设备/重工业', value: '29' },
            { label: '加工制造（原料加工/模具）', value: '30' },
            { label: '仪器仪表及工业自动化', value: '31' },
            { label: '印刷/包装/造纸', value: '32' },
            { label: '办公用品及设备', value: '33' },
            { label: '医药/生物工程', value: '34' },
            { label: '医疗设备/器械', value: '35' },
            { label: '航空/航天研究与制造', value: '36' },
            { label: '交通/运输,物流/仓储', value: '37' },
            { label: '医疗/护理/美容/保健/卫生服务', value: '38' },
            { label: '酒店/餐饮,旅游/度假,媒体/出版/影视/文化传播', value: '39' },
            { label: '娱乐/体育/休闲', value: '40' },
            { label: '能源/矿产/采掘/冶炼', value: '41' },
            { label: '石油/石化/化工,电气/电力/水利', value: '42' },
            { label: '环保', value: '43' },
            { label: '政府/公共事业/非盈利机构', value: '44' },
            { label: '学术/科研,农/林/牧/渔跨领域经营', value: '45' },
            { label: '其他', value: '90' }
          ],
          label: '行业类别',
          model: 'industry',
          rules: [{ required: true, message: '请选择行业类别', trigger: 'change' }]
        },
        {
          type: 'v-input',
          label: '工作部门',
          model: 'dept_cn',
          attrs: { placeholder: '请输入工作部门' },
          rules: [{ required: true, message: '请输入工作部门', trigger: 'blur' }]
        },
        {
          type: 'v-input',
          label: '工作职位',
          model: 'position_cn',
          attrs: { placeholder: '请输入工作职位' },
          rules: [{ required: true, message: '请输入工作职位', trigger: 'blur' }]
        },
        {
          type: 'v-input',
          label: '工作描述',
          model: 'job_desc_cn',
          attrs: {
            type: 'textarea',
            placeholder: '请输入工作描述',
            rows: '8',
            maxlength: '3000'
          },
          rules: [{ required: true, message: '请输入工作描述', trigger: 'blur' }]
        }
      ]
    }
  }
}
