import BaseAPI from './base_api'

export default class ScoreAPI extends BaseAPI {
  //zws/v1/cms/news
  /**
   * zws项目内容获取
   */
  getContent = name =>
    this.get(
      `zws/v1/cms/projects/1011/contents/${encodeURIComponent(decodeURIComponent(name))}?sites=seg-him.ezijing.com`,
      {}
    )
  /**
   * zws新闻/消息获取
   */
  getNews = (obj = {}) => this.get('/zws/v1/cms/news', obj, {})
  /**
   * 获取当前状态值
   * project_id [int] 项目id
   */
  getStatus = (obj = {}) => this.get('zws/v1/enrollment/submissions', obj, {})
  /**
   * 获取测评系统测试地址
   */
  getexamTestUrl = () => this.get('usercenter/v1/evaluation/get-address', {}, {})
}
