/**
 * 学习目的
 */

export default function(_this) {
  return {
    id: 'application_info_answer',
    title: '学习目的',
    required: true,
    visible() {
      return _this.visible
    },
    get: {
      action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/${webConf.others.projectId}`,
      callback(data) {
        const { answers = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        this.form.options.disabled = submissionStage !== 'FILLING'

        const [first = {}, second = {}, third = {}, fourth = {}] = answers
        return {
          qid1: first.qid || '1',
          question1: first.question || '自我介绍',
          answer1: first.answer,
          qid2: second.qid || '2',
          question2: second.question || '这个MAP计划对你个人将来有什么好处？你在这个项目中的个人发展目标是什么？',
          answer2: second.answer,
          qid3: third.qid || '3',
          question3: third.question || '这个MAP计划对你将来的职业发展有什么好处？你的职业发展目标是什么？',
          answer3: third.answer,
          qid4: fourth.qid || '4',
          question4:
            fourth.question || '你参加过心理学的工作坊或培训班吗？请把它列出来。你是如何从这些学习经验中获益的？',
          answer4: fourth.answer
        }
      }
    },
    update: {
      action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/${webConf.others.projectId}/put`,
      beforeRequest(data) {
        return {
          answers: [
            { qid: data.qid1, question: data.question1, answer: data.answer1 },
            { qid: data.qid2, question: data.question2, answer: data.answer2 },
            { qid: data.qid3, question: data.question3, answer: data.answer3 },
            { qid: data.qid4, question: data.question4, answer: data.answer4 }
          ]
        }
      }
    },
    form: {
      prev: { to: { query: { active: 'application_info', tab: 'application_info_career' } }, isSubmit: true },
      next: { to: { query: { active: 'application_info', tab: 'application_info_training' } }, isSubmit: true },
      options: { 'label-position': 'top' },
      items: [
        {
          type: 'v-input',
          label:
            '自我介绍（简述自己与心理学的渊源；对心理学的兴趣，什么促使自身喜欢心理学；讲一个与内心活动有关的故事）',
          model: 'answer1',
          attrs: { type: 'textarea', rows: '8', maxlength: '1000', style: 'width:100%' },
          rules: [
            { required: true, message: '请输入', trigger: 'blur' },
            { min: 60, max: 1000, message: '长度在 60 到 1000 个字符', trigger: 'blur' }
          ]
        },
        {
          type: 'v-input',
          label:
            '这个MAP计划对你个人将来有什么好处？你在这个项目中的个人发展目标是什么？（聚焦在MAP学习对个人成长的帮助；如何实现自我目标和个人的社会价值）',
          model: 'answer2',
          attrs: { type: 'textarea', rows: '8', maxlength: '1000', style: 'width:100%' },
          rules: [
            { required: true, message: '请输入', trigger: 'blur' },
            { min: 60, max: 1000, message: '长度在 60 到 1000 个字符', trigger: 'blur' }
          ]
        },
        {
          type: 'v-input',
          label:
            '这个MAP计划对你将来的职业发展有什么好处？你的职业发展目标是什么？（紧密联系MAP课程对目前职业的直接帮助；对未来职业发展目标的支持；如何通过职业平台把所学的心理学技能帮助到更多有需要的人)',
          model: 'answer3',
          attrs: { type: 'textarea', rows: '8', maxlength: '1000', style: 'width:100%' },
          rules: [
            { required: true, message: '请输入', trigger: 'blur' },
            { min: 60, max: 1000, message: '长度在 60 到 1000 个字符', trigger: 'blur' }
          ]
        },
        {
          type: 'v-input',
          label: '你参加过心理学的工作坊或培训班吗？请把它列出来。你是如何从这些学习经验中获益的？',
          model: 'answer4',
          attrs: { type: 'textarea', rows: '8', maxlength: '1000', style: 'width:100%' },
          rules: [
            { required: true, message: '请输入', trigger: 'blur' },
            { min: 60, max: 1000, message: '长度在 60 到 1000 个字符', trigger: 'blur' }
          ]
        }
      ]
    }
  }
}
