import Vue from 'vue' // 引入vue框架
import VuePassport from '@ezijing/vue-passport'
import '@ezijing/vue-passport/dist/vue-passport.css'
import VueForm from '@ezijing/vue-form'
import '@ezijing/vue-form/dist/vue-form.css'
import Element from 'element-ui' // 引入 element-ui 框架
import './style.scss' // 定义 element-ui主题色 + 公共样式
import router from './router' // router定义
import store from './store'
import App from './app.vue'
import Calendar from 'vue-mobile-calendar'
Vue.use(Calendar)

// import cTool from '@tool'
/* 引入 md5 */
import md5 from 'js-md5'
/* 定义全局变量 */
import BeforeRouter from './components/before'

Vue.use(Element)
Vue.use(VueForm)
Vue.use(VuePassport)
/* 设置全局变量 */
window.G = Vue.prototype.$GlobalVariable = {
  VERSION: 'PC-1.5.6'
}
Vue.prototype.$md5 = md5

/* 导航守卫 */
router.beforeEach(async (to, from, next) => {
  /* 设置 全局变量 */
  BeforeRouter.globalVariable.init(Vue, { to, from, next })
  if (to.meta.requiredLogin) {
    const isLogin = await BeforeRouter.loginInfo.isLogin(Vue)
    isLogin ? next() : next({ path: '/index', query: { needLogin: Date.now() } })
  } else {
    next()
  }
})
/**
 * 定义全局变量 - 用作全局事件发布订阅
 * 使用 vue自带事件 $emit 和 $on 进行发布订阅
 */
Vue.prototype.VueEvent = new Vue()

// /* 定义全局 jquery 变量 */
// Vue.prototype.jq = $

new Vue({
  store,
  router,
  render: h => h(App)
}).$mount('#app')
