export default function(_this) {
  return {
    id: 'admission_xfjn',
    title: '学费缴纳',
    get: {
      action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/${webConf.others.projectId}`,
      callback(data) {
        const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        const stageList = ['FILLING', 'PREPAYMENT', 'INTERVIEW_APPLICATION', 'AUDITION', 'INTERVIEW', 'PAYMENT', 'REGISTRATION', 'CLOSED']
        this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 6
        const PAYMENT_VOUCHER = attachments.filter(item => {
          return item.file_type_id === 'PAYMENT_VOUCHER'
        })
        return { PAYMENT_VOUCHER }
      }
    },
    form: {
      prev: { to: { query: { active: 'admission_xy' } } },
      hasButton: false,
      options: { 'label-position': 'top' },
      hint: `<div style="line-height:34px;">
        <p><strong>一、对公收款银行信息：</strong></p>
        <p>户名：清控紫荆（ 北京）教育科技股份有限公司</p>
        <p>帐号：694485289</p>
        <p>开户行：中国民生银行股份有限公司北京魏公村支行</p>
        <p style="margin-top:30px;"><strong>二、支付宝收款账户信息：</strong></p>
        <p>支付宝账号：service@ezijing.com</p>
        <p>支付宝户名：清控紫荆（北京）教育科技股份有限公司</p></div>`,
      items: [
        {
          type: 'v-upload',
          model: 'PAYMENT_VOUCHER',
          label: '上传缴费凭证',
          attrs: {
            action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/put`,
            deleteAction: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/delete`,
            data: { file_type: 'PAYMENT_VOUCHER' }
          },
          append: `<div style="line-height:24px;margin-top:10px;">申请者可将转账/支付缴费凭证截图或拍照后提交。<br/>
          上传文件仅限“jpg,jpeg,pdf,png”格式，文件小于10Mb。</div>`
        }
      ]
    }
  }
}
