import Layout from '@/components/layout'

export default [
  { path: '*', redirect: '/' },
  {
    path: '/',
    component: Layout,
    children: [
      { path: '', redirect: '/index' },
      { path: '/index', component: () => import('@/pages/home/index.vue') },
      // 工作动态
      { path: '/news', component: () => import('@/pages/news/index.vue') },
      // 工作动态详情
      { path: '/news/detail', component: () => import('@/pages/news/detail.vue') },
      // 1+x产品
      { path: '/product', component: () => import('@/pages/product/index.vue') },
      // 师资培训
      { path: '/teacher', component: () => import('@/pages/teachers/index.vue') },
      // 证书成绩查询
      { path: '/attestation', component: () => import('@/pages/attestation/index.vue') },
      // // 教学服务
      { path: '/service', component: () => import('@/pages/service/index.vue') },
      { path: '/train', component: () => import('@/pages/train/index.vue') },
      // 师资培训详情
      { path: '/train/detail', component: () => import('@/pages/train/detail.vue') },
      // 师资培训详情->报名
      { path: '/train/form', component: () => import('@/pages/train/form.vue') },
      { path: '/school/form', component: () => import('@/pages/train/form2.vue') },
      { path: '/register', component: () => import('@/pages/account/register.vue') },
      // 证书成绩查询
      { path: '/queryCard', component: () => import('@/pages/home/queryCard.vue') }
      // // 教材中心
      // { path: '/textBook', component: () => import('@/pages/textBook/index.vue') },
      // // 教材中心详情
      // { path: '/textBook/detail', component: () => import('@/pages/textBook/detail.vue') },
      // // 教材中心详情->章节
      // { path: '/textBook/chapter', component: () => import('@/pages/textBook/chapter.vue') },
      // // 师资培训详情
      // { path: '/train/detail', component: () => import('@/pages/train/detail.vue') },
      // // 师资培训详情->报名
      // { path: '/train/form', component: () => import('@/pages/train/form.vue') },
      // { path: '/school/form', component: () => import('@/pages/train/form2.vue') },
      // // 考核站点
      // { path: '/site', component: () => import('@/pages/site/index.vue') },

      // // 办事大厅
      // { path: '/hall', component: () => import('@/pages/hall/index.vue') },
      // // 教学服务
      // { path: '/service', component: () => import('@/pages/service/index.vue') },
      // { path: '/introduce', component: () => import('@/pages/home/newIntroduce.vue') },
      // { path: '/queryCard', component: () => import('@/pages/home/queryCard.vue') }
    ]
  },
  // 考核站点详情
  { path: '/site/detail', component: () => import('@/pages/site/detail.vue') }
]
