import Layout from '@/components/layout/index.vue'
export const routes = [
  { path: '*', redirect: '/index' },
  {
    path: '/index',
    component: Layout,
    props: { fixed: true, footer: true },
    children: [{ path: '', component: () => import('@/pages/homepage/index.vue'), name: 'home-page' }]
  },
  // 专业设置
  {
    path: '/profession',
    component: Layout,
    props: { fixed: true, footer: true },
    children: [{ name: 'major-set', path: '', component: () => import('@/pages/major-set/index.vue') }]
  },
  // 最新动态
  {
    path: '/news',
    component: Layout,
    props: { fixed: true, footer: true },
    children: [
      { name: 'recent-news', path: '', component: () => import('@/pages/recent-news/index.vue') },
      {
        name: 'details-recent-news',
        path: ':id',
        component: () => import('@/pages/details-news/index.vue'),
        meta: { title: '最新动态', details: true }
      }
    ]
  },
  // 联系我们
  {
    name: 'contact-us',
    path: '/contact',
    component: Layout,
    props: { fixed: true, footer: true },
    children: [{ path: '', component: () => import('@/pages/contact-us/index.vue') }]
  },
  // 在线报名
  {
    path: '/my',
    component: Layout,
    meta: { title: '在线报名', details: true, userRole: true },
    children: [
      {
        name: 'apply',
        path: '',
        component: () => import(/* webpackChunkName: "my-welcome" */ '@/pages/my/welcome/index.vue'),
        meta: { userRole: true, details: true }
      },
      {
        name: 'account',
        path: 'account',
        component: () => import(/* webpackChunkName: "my-account" */ '@/pages/my/account/index.vue'),
        meta: { userRole: true, details: true }
      },
      {
        path: 'application',
        component: () => import(/* webpackChunkName: "my-application" */ '@/pages/my/application/index.vue'),
        meta: { userRole: true, details: true }
      },
      {
        path: 'interview',
        component: () => import(/* webpackChunkName: "my-interview" */ '@/pages/my/interview/index.vue'),
        meta: { userRole: true, details: true }
      },
      {
        path: 'admission',
        component: () => import(/* webpackChunkName: "my-admission" */ '@/pages/my/admission/index.vue'),
        meta: { userRole: true, details: true }
      }
    ]
  },
  // 推荐信
  {
    path: '/letter',
    component: () => import(/* webpackChunkName: "letter" */ '@/pages/letter/index.vue')
  },
  {
    path: '/application-materials/reco-letters/submit/:projectId/:userId/:letterId',
    component: () => import(/* webpackChunkName: "letter" */ '@/pages/letter/index.vue')
  },
  // 登录
  {
    path: '/login',
    component: Layout,
    children: [
      {
        name: 'login',
        path: '',
        component: () => import(/* webpackChunkName: "passport" */ '@/pages/login/index.vue'),
        meta: { details: true }
      }
    ]
  },
  // 注册
  {
    path: '/register',
    component: Layout,
    children: [
      {
        name: 'register',
        path: '',
        component: () => import(/* webpackChunkName: "passport" */ '@/pages/register/index.vue'),
        meta: { details: true }
      }
    ]
  },
  // 忘记密码
  {
    path: '/password',
    component: Layout,
    children: [
      {
        name: 'forgetPsw',
        path: '',
        component: () => import(/* webpackChunkName: "passport" */ '@/pages/forgetPsw/index.vue'),
        meta: { details: true }
      }
    ]
  },
  {
    path: '/preview',
    props: { isManager: true },
    component: () => import(/* webpackChunkName: "preview" */ '@/pages/my/application/preview.vue')
  },
  {
    path: '/complete',
    component: () => import(/* webpackChunkName: "complete" */ '@/pages/my/application/complete.vue')
  }
]
