export default {
  id: 'interview_cjd',
  title: '成绩单（中/英）',
  get: {
    action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/${webConf.others.projectId}`,
    callback(data) {
      const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
      const stageList = [
        'FILLING',
        'PREPAYMENT',
        'INTERVIEW_APPLICATION',
        'AUDITION',
        'INTERVIEW',
        'PAYMENT',
        'REGISTRATION',
        'CLOSED'
      ]
      this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 2
      return attachments.reduce(
        (result, item) => {
          if (item.file_type_id === 'REPORT_CARD_CN') {
            result.REPORT_CARD_CN.push(item)
          }
          if (item.file_type_id === 'REPORT_CARD_EN') {
            result.REPORT_CARD_EN.push(item)
          }
          return result
        },
        { REPORT_CARD_CN: [], REPORT_CARD_EN: [] }
      )
    }
  },
  form: {
    prev: { to: { query: { active: 'interview_byz' } } },
    next: { to: { query: { active: 'interview_zp' } } },
    hasButton: false,
    options: { 'label-position': 'top' },
    hint: `
      <p>成绩单：中/英文成绩单上传一个或多个。</p>
      <p>注意事项：需要将证书原件扫描或拍照后提交，请确保证书内容清晰可辨。</p>
    `,
    items: [
      {
        type: 'v-upload',
        label: '中/英文成绩单',
        required: true,
        model: 'REPORT_CARD_CN',
        attrs: {
          action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/put`,
          deleteAction: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/delete`,
          data: { file_type: 'REPORT_CARD_CN' }
        }
      }
    ]
  }
}
