export default function(_this) {
  return {
    id: 'admission_xy',
    title: '入学协议',
    get: {
      action: `/api/enrollment/v1.0/application-materials/${webConf.others.projectId}`,
      callback(data) {
        const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        const stageList = [
          'FILLING',
          'PREPAYMENT',
          'INTERVIEW_APPLICATION',
          'AUDITION',
          'INTERVIEW',
          'PAYMENT',
          'REGISTRATION',
          'CLOSED'
        ]
        this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 6
        const ADMISSION_AGREEMENT = attachments.filter(item => {
          return item.file_type_id === 'ADMISSION_AGREEMENT'
        })
        return { ADMISSION_AGREEMENT }
      }
    },
    form: {
      next: { to: { query: { active: 'admission_xfjn' } } },
      hasButton: false,
      options: {},
      items: [
        {
          type: 'v-upload',
          required: true,
          model: 'ADMISSION_AGREEMENT',
          attrs: {
            action: `/api/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/put`,
            deleteAction: `/api/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/delete`,
            data: { file_type: 'ADMISSION_AGREEMENT' }
          },
          prepend: `
            <p><a href="https://zws-imgs-pub.ezijing.com/static/public/41b2a4ae91c6826dc5f9daa3ebf345eb.docx" target="_blank" download="入学协议">下载入学协议</p>
            <p>申请者可将签字后的入学协议原件扫描或拍照后提交。</p>
            <p>学员应仔细阅读《入学协议》以及课程介绍，如对入学协议或课程有异议，请第一时间与课程顾问咨询确认。请用A4纸打印后，在入学协议上签上姓名和日期，内容需显示完整、格式整齐、字迹清晰可辨。上传文件仅限“jpg,jpeg,pdf,png”格式，文件小于10Mb。</p>
          `
        }
      ]
    }
  }
}
