export default {
  id: 'interview_xwzsywzm',
  title: '学位证书英文证明',
  get: {
    action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/${window.PROJECT_ID}`,
    callback(data) {
      const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
      const stageList = [
        'FILLING',
        'PREPAYMENT',
        'INTERVIEW_APPLICATION',
        'AUDITION',
        'INTERVIEW',
        'PAYMENT',
        'REGISTRATION',
        'CLOSED'
      ]
      this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 2
      const DEGREE_CERT_EN = attachments.filter(item => {
        return item.file_type_id === 'DEGREE_CERT_EN'
      })
      return { DEGREE_CERT_EN }
    }
  },
  form: {
    prev: { to: { query: { active: 'interview_xwzs' } } },
    next: { to: { query: { active: 'interview_ywjl' } } },
    hasButton: false,
    options: {},
    items: [
      {
        type: 'v-upload',
        required: true,
        model: 'DEGREE_CERT_EN',
        attrs: {
          action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${window.PROJECT_ID}/put`,
          deleteAction: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${window.PROJECT_ID}/delete`,
          data: { file_type: 'DEGREE_CERT_EN' }
        },
        append: '请将学校出具的学位证书英文证明原件扫描或者拍照后提交。'
      }
    ]
  }
}
