import Vue from 'vue'
import Vuex from 'vuex'
import router from '@/router'
import { constantRoutes } from '@/router/routes.js'
import { logout } from '@/api/my'

Vue.use(Vuex)

export default new Vuex.Store({
  state: {
    sidebar: []
  },
  getters: {
    getSidebar: state => state.sidebar
  },
  mutations: {
    SET_ROUTES: (state, routes) => {
      state.sidebar = routes
    }
  },
  actions: {
    generateRoutes({ commit }) {
      return new Promise(resolve => {
        commit('SET_ROUTES', constantRoutes)
        resolve(constantRoutes)
      })
    },
    logout() {
      return logout().then(() => {
        // router.push('/')
        window.location.href = '/'
      })
    }
  }
})
