import Vue from 'vue'
import Vuex from 'vuex'
// import router from '@/router'
import { routes } from '@/router/routes.js'
import { logout } from '@/api/my'

Vue.use(Vuex)

export default new Vuex.Store({
  state: {
    sidebar: []
  },
  getters: {
    getSidebar: state => state.sidebar
  },
  mutations: {
    SET_ROUTES: (state, routes) => {
      state.sidebar = routes
    }
  },
  actions: {
    generateRoutes({ commit }) {
      return new Promise(resolve => {
        commit('SET_ROUTES', routes)
        resolve(routes)
      })
    },
    logout() {
      return logout().then(() => {
        // router.push('/')
        window.location.href = '/'
      })
    }
  }
})
