/**
 * 个人信息
 */

import country from './country'

export default function(_this) {
  return {
    id: 'application_info_profile',
    title: '个人信息',
    required: true,
    visible() {
      return _this.visible
    },
    get: {
      action: `/api/enrollment/v1.0/application-materials/${webConf.others.projectId}`,
      callback(data) {
        const {
          basic_info: basicInfo = {},
          attachments = [],
          submission_stage: submissionStage = 'FILLING'
        } = data.data.material
        this.form.options.disabled = submissionStage !== 'FILLING'

        const attachment = attachments.reduce(
          (result, item) => {
            const types = ['ID_CARD_FRONT', 'ID_CARD_BACK', 'HK_ID_CARD', 'PASSPORT', 'OTHER_ID_CARD_PHOTO']
            types.forEach(type => {
              if (item.file_type_id === type) {
                result[type].push(item)
              }
            })
            return result
          },
          { ID_CARD_FRONT: [], ID_CARD_BACK: [], HK_ID_CARD: [], PASSPORT: [], OTHER_ID_CARD_PHOTO: [] }
        )
        return Object.assign({}, basicInfo, attachment)
      }
    },
    update: {
      action: `/api/enrollment/v1.0/application-materials/${webConf.others.projectId}/put`,
      beforeRequest(data) {
        // let [province, city] = data.city.split('-')
        // data.address_province = province
        // data.address_city = city
        const basicInfo = [
          'phone_number',
          'email',
          'id_type',
          'id_number',
          'real_name_cn',
          'real_name_en',
          'gender',
          'nationality',
          'birthday',
          'address_province',
          'address_city',
          'we_chat_account',
          'mailing_address',
          'emergency_contact_name',
          'emergency_contacts_phone'
        ].reduce((result, key) => {
          result[key] = data[key]
          return result
        }, {})
        return { basic_info: basicInfo }
      }
    },
    form: {
      prev: { to: { query: { active: 'application_info', tab: 'application_info_first' } } },
      next: { to: { query: { active: 'application_info', tab: 'application_info_education' } }, isSubmit: true },
      options: { labelWidth: '140px' },
      items: [
        {
          type: 'v-input',
          label: '手机号',
          model: 'phone_number',
          attrs: { placeholder: '请输入手机号', maxlength: 11 },
          rules: [{ required: true, pattern: /^1[3-9]\d{9}$/, message: '请输入手机号', trigger: 'blur' }]
        },
        {
          type: 'v-input',
          label: '邮箱',
          model: 'email',
          attrs: { placeholder: '请输入邮箱' },
          rules: [{ type: 'email', required: true, message: '请输入邮箱', trigger: 'blur' }],
          hint: '（后续报名信息将发送至此邮箱，请认真填写）'
        },
        {
          type: 'v-select',
          values: [{ value: '居民身份证' }, { value: '港澳台身份证' }, { value: '护照' }, { value: '其他' }],
          label: '证件类型',
          model: 'id_type',
          attrs: { placeholder: '请选择证件类型' },
          rules: [{ required: true, message: '请选择证件类型', trigger: 'change' }]
        },
        // 身份证照片(背面)
        {
          type: 'v-upload',
          label: '身份证人像面',
          model: 'ID_CARD_BACK',
          attrs: {
            action: `/api/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/put`,
            deleteAction: `/api/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/delete`,
            data: { file_type: 'ID_CARD_BACK' },
            limit: 1,
            image: 'https://zws-imgs-pub.oss-cn-beijing.aliyuncs.com/pc/cu/id_card_back.png'
          },
          rules: [{ type: 'array', required: true, message: '请上传身份证照片人像面', trigger: 'change' }],
          isShow(data) {
            return data.id_type === '居民身份证'
          }
        },
        // 身份证照片(正面）
        {
          type: 'v-upload',
          label: '身份证国徽面',
          model: 'ID_CARD_FRONT',
          attrs: {
            action: `/api/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/put`,
            deleteAction: `/api/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/delete`,
            data: { file_type: 'ID_CARD_FRONT' },
            limit: 1,
            image: 'https://zws-imgs-pub.oss-cn-beijing.aliyuncs.com/pc/cu/id_card_front.png'
          },
          rules: [{ type: 'array', required: true, message: '请上传身份证照片国徽面', trigger: 'change' }],
          isShow(data) {
            return data.id_type === '居民身份证'
          }
        },
        // 港澳台身份证
        {
          type: 'v-upload',
          label: '港澳台身份证',
          model: 'HK_ID_CARD',
          attrs: {
            action: `/api/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/put`,
            deleteAction: `/api/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/delete`,
            data: { file_type: 'HK_ID_CARD' },
            limit: 1
          },
          rules: [{ type: 'array', required: true, message: '请上传港澳台身份证', trigger: 'change' }],
          isShow(data) {
            return data.id_type === '港澳台身份证'
          }
        },
        // 护照
        {
          type: 'v-upload',
          label: '护照',
          model: 'PASSPORT',
          attrs: {
            action: `/api/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/put`,
            deleteAction: `/api/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/delete`,
            data: { file_type: 'PASSPORT' },
            limit: 1
          },
          rules: [{ type: 'array', required: true, message: '请上传护照', trigger: 'change' }],
          isShow(data) {
            return data.id_type === '护照'
          }
        },
        // 其他证件
        {
          type: 'v-upload',
          label: '其他证件',
          model: 'OTHER_ID_CARD_PHOTO',
          attrs: {
            action: `/api/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/put`,
            deleteAction: `/api/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/delete`,
            data: { file_type: 'OTHER_ID_CARD_PHOTO' },
            limit: 1
          },
          rules: [{ type: 'array', required: true, message: '请上传其他证件', trigger: 'change' }],
          isShow(data) {
            return data.id_type === '其他'
          }
        },
        {
          type: 'v-input',
          label: '证件号码',
          model: 'id_number',
          attrs: { placeholder: '请输入证件号码' },
          rules: [{ required: true, message: '请输入证件号码', trigger: 'blur' }]
        },
        {
          type: 'v-input',
          label: '姓名',
          model: 'real_name_cn',
          attrs: { placeholder: '请输入姓名' },
          rules: [{ required: true, message: '请输入姓名', trigger: 'blur' }]
        },
        {
          type: 'v-input',
          label: '英文名',
          model: 'real_name_en',
          attrs: { placeholder: '请输入英文名' },
          rules: [{ required: true, message: '请输入英文名', trigger: 'blur' }]
        },
        {
          type: 'v-radio',
          values: [
            { label: '男', value: '男' },
            { label: '女', value: '女' }
          ],
          label: '性别',
          model: 'gender',
          rules: [{ required: true, message: '请选择性别', trigger: 'change' }]
        },
        {
          type: 'v-select',
          label: '国籍',
          model: 'nationality',
          values: country,
          attrs: { placeholder: '请选择国籍', filterable: true },
          rules: [{ required: true, message: '请选择国籍', trigger: 'blur' }]
        },
        {
          type: 'v-datepicker',
          label: '出生日期',
          model: 'birthday',
          attrs: { type: 'date', placeholder: '请选择出生日期', valueFormat: 'yyyy-MM-dd' },
          rules: [{ required: true, message: '请选择出生日期', trigger: 'blur' }]
        },
        {
          type: 'v-input',
          label: '居住省',
          model: 'address_province',
          attrs: { placeholder: '请输入居住省' },
          rules: [{ required: true, message: '请输入居住省', trigger: 'blur' }]
        },
        {
          type: 'v-input',
          label: '居住市',
          model: 'address_city',
          attrs: { placeholder: '请输入居住市' },
          rules: [{ required: true, message: '请输入居住市', trigger: 'blur' }]
        },
        // {
        //   type: 'city-v-select',
        //   label: '现居住城市',
        //   model: 'city',
        //   separator: '-',
        //   rules: [{ required: true, message: '请选择居住城市', trigger: 'blur' }]
        // },
        {
          type: 'v-input',
          label: '微信号',
          model: 'we_chat_account',
          attrs: { placeholder: '请输入微信号' },
          rules: [{ required: true, message: '请输入微信号', trigger: 'blur' }]
        },
        {
          type: 'v-input',
          label: '邮寄地址',
          model: 'mailing_address',
          attrs: { placeholder: '请输入邮寄地址' },
          rules: [{ required: true, message: '请输入邮寄地址', trigger: 'blur' }]
        },
        {
          type: 'v-input',
          label: '紧急联系人',
          model: 'emergency_contact_name',
          attrs: { placeholder: '请输入紧急联系人' },
          rules: [{ required: true, message: '请输入紧急联系人', trigger: 'blur' }]
        },
        {
          type: 'v-input',
          label: '紧急联系电话',
          model: 'emergency_contacts_phone',
          attrs: { placeholder: '请输入紧急联系电话' },
          rules: [{ required: true, message: '请输入紧急联系电话', trigger: 'blur' }]
        }
      ]
    }
  }
}
