export default class Cookies {
/*
  name: cookies的名字，也是cookies的唯一标识，通过他来获取和设置cookies
  value：cookies的值，也就是cookies的内容，这是cookies有用的内容
  Domain：cookies所属的域
  Path: cookies所属的路径，他是属于某个路径的，/代表根路径
  expires：cookies的到期时间，如果为0则永不过期
  http: 如果打钩则通过脚本无法获取，可以防止xss攻击
  secure：https连接才会传送该cookies，增强了安全性
  sameSite：可选值Strict 和 Lax，Strict 严格模式，不能被第三方网站获取，Lax：宽松模式，可以被第三方获取
*/
  /* 如果 http 打钩，则 这边的 脚本函数将全部失效，而线上就是这么做的 */

  /**
   * 设置 Cookies，用于客户端
   * @param {[string]} cName 要设置cookie的key值
   * @param {[string]} cValue 要设置cookie的value值
   * @param {[object]} obj 要设置cookie的其他值
   * @param {[object]} obj.path 路径
   * @param {[object]} obj.domain 域名
   * @param {[object]} obj.expires 过期时间
   */
  setCookie (cName, cValue, obj) {
    const d = new Date()
    if (obj.expires) {
      d.setTime(d.getTime() + ((obj.expires || 0) * 24 * 60 * 60 * 1000))
      obj.expires = d.toUTCString()
    }
    let str = ''
    for (const key in obj) {
      str += '; ' + key + '=' + obj[key]
    }
    document.cookie = cName + '=' + cValue + str
  }

  /**
   * 获取指定cookie，用于客户端
   * @param {[string]} cName 要获取cookie的key值
   */
  getCookie (cName) {
    const key = cName + '='
    const ca = document.cookie.split(';')
    for (let i = 0; i < ca.length; i++) {
      let c = ca[i]
      while (c.charAt(0) === ' ') c = c.substring(1)
      if (c.indexOf(key) !== -1) {
        return c.substring(key.length, c.length)
      }
    }
    return ''
  }

  /**
   * 获取全cookie，用于客户端
   */
  getAllCookies () {
    return document.cookie
  }

  /**
   * 清除cookie，用于客户端
   * 需要path 和 domain 唯一确定 一个 cookie
   * @param {[string]} cName 要清除cookie的key值
   * @param {[object]} obj.path 路径
   * @param {[object]} obj.domain 域名
   * @param {[object]} obj.expires 过期时间
   */
  clearCookie (cName, obj) {
    const exp = new Date() // 获取客户端本地当前系统时间
    // 将exp设置为客户端本地时间1分钟以前，将exp赋值给cookie作为过期时间后，就表示该cookie已经过期了, 那么浏览器就会将其立刻删除掉
    exp.setTime(exp.getTime() - 60 * 1000)
    obj.expires = exp.toUTCString()
    let str = ''
    for (const key in obj) {
      str += '; ' + key + '=' + obj[key]
    }
    document.cookie = cName + '=' + str
  }
}
