export default function(_this) {
  return {
    id: 'interview_zp',
    title: '2寸照片',
    get: {
      action: `/api/enrollment/v1.0/application-materials/${webConf.others.projectId}`,
      callback(data) {
        const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        const stageList = [
          'FILLING',
          'PREPAYMENT',
          'INTERVIEW_APPLICATION',
          'AUDITION',
          'INTERVIEW',
          'PAYMENT',
          'REGISTRATION',
          'CLOSED'
        ]
        this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 2
        const PERSONAL_PHOTO_FOR_ID = attachments.filter(item => {
          return item.file_type_id === 'PERSONAL_PHOTO_FOR_ID'
        })
        return { PERSONAL_PHOTO_FOR_ID }
      }
    },
    update: {
      action: `/api/enrollment/v1.0/application-materials/submit/${webConf.others.projectId}`,
      beforeRequest(data) {
        return { submission_stage: 'INTERVIEW_APPLICATION' }
      },
      callback() {
        this.form.options.disabled = true
        _this.dialogVisible = true
        _this.getApplication()
      },
      errorCallback() {
        _this.completeVisible = true
      }
    },
    form: {
      prev: { to: { query: { active: 'interview_cjd' } } },
      submitText: '申请面试',
      model: { submission_stage: 'INTERVIEW_APPLICATION' },
      options: {},
      items: [
        {
          type: 'v-upload',
          model: 'PERSONAL_PHOTO_FOR_ID',
          attrs: {
            action: `/api/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/put`,
            deleteAction: `/api/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/delete`,
            data: { file_type: 'PERSONAL_PHOTO_FOR_ID' }
          },
          prepend: '2寸照片：以电子版的形式上传文件',
          append: '注意事项：需要将证书原件扫描或拍照后提交，请确保证书内容清晰可辨。'
        }
      ]
    }
  }
}
