import Vue from 'vue'
import Vuex from 'vuex'
import { constantRoutes } from '@/router/routes.js'

Vue.use(Vuex)

export default new Vuex.Store({
  state: {
    sidebar: []
  },
  getters: {
    getSidebar: state => state.sidebar
  },
  mutations: {
    SET_ROUTES: (state, routes) => {
      state.sidebar = routes
    }
  },
  actions: {
    generateRoutes({ commit }) {
      return new Promise(resolve => {
        commit('SET_ROUTES', constantRoutes)
        resolve(constantRoutes)
      })
    }
  }
})
