import cAction from '@action'

import { Message } from 'element-ui'

export default class Before {
  constructor(opt) {
    this.opt = opt || {}
  }

  async update(to, from, next) {
    if (to.meta && to.meta.userRole) {
      const isLogin = await this.isLogin()
      if (isLogin) {
        next()
      } else {
        next({ path: '/login' })
      }
    } else {
      next()
    }
  }

  /* 获取用户信息 */
  isLogin() {
    return cAction.Test.getInfo()
      .then(res => {
        if (res.code === 0) {
          window.G.UserInfo = res.data
          return true
        } else {
          return false
        }
      })
      .catch(res => {
        Message({ type: 'error', message: res.message })
        return false
      })
  }
}
