/**
 * 教育背景
 */

export default function(_this) {
  return {
    id: 'application_info_education',
    title: '教育背景',
    required: true,
    visible() {
      return _this.visible
    },
    get: {
      action: `/api/enrollment/v1.0/application-materials/${webConf.others.projectId}`,
      callback(data) {
        let { educations: list = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        this.form.options.disabled = submissionStage !== 'FILLING'

        list = list.map(item => {
          const { start_date: startDate, end_date: endDate } = item
          if (startDate) {
            item.dates = [startDate, endDate]
          }
          return item
        })
        return list.length ? list : [{}]
      }
    },
    update: {
      action: `/api/enrollment/v1.0/application-materials/${webConf.others.projectId}/put`,
      beforeRequest(data) {
        const educations = data.map(item => {
          const [startDate, endDate] = item.dates
          item.start_date = startDate
          item.end_date = endDate
          return ['start_date', 'end_date', 'school_name_cn', 'major_cn', 'degree'].reduce((result, key) => {
            result[key] = item[key]
            return result
          }, {})
        })
        return { educations }
      }
    },
    form: {
      prev: { to: { query: { active: 'application_info', tab: 'application_info_profile' } }, isSubmit: true },
      next: { to: { query: { active: 'application_info', tab: 'application_info_career' } }, isSubmit: true },
      hasAdd: true,
      options: { labelWidth: '140px' },
      items: [
        {
          type: 'v-datepicker',
          label: '教育时间',
          model: 'dates',
          attrs: {
            type: 'monthrange',
            rangeSeparator: '至',
            startPlaceholder: '请选择开始时间',
            endPlaceholder: '请选择结束时间',
            valueFormat: 'yyyy-MM'
          },
          rules: [{ required: true, message: '请选择教育时间', trigger: 'blur' }]
        },
        {
          type: 'v-input',
          label: '学校名称',
          model: 'school_name_cn',
          rules: [{ required: true, message: '请输入学校名称', trigger: 'blur' }]
        },
        {
          type: 'v-input',
          label: '专业名称',
          model: 'major_cn',
          rules: [{ required: true, message: '请输入专业名称', trigger: 'blur' }]
        },
        {
          type: 'v-select',
          values: [
            { value: '专科' },
            { value: '本科' },
            { value: '本科/学士' },
            { value: '硕士研究生' },
            { value: '研究生/硕士' },
            { value: '博士研究生' },
            { value: '研究生/博士' },
            { value: '其他' }
          ],
          label: '学历/学位',
          model: 'degree',
          rules: [{ required: true, message: '请选择学历/学位', trigger: 'change' }]
        }
      ]
    }
  }
}
