/**
 * 所受培训
 */

export default function(_this) {
  return {
    id: 'application_info_training',
    title: '所受培训',
    visible() {
      return _this.visible
    },
    get: {
      action: `/api/enrollment/v1.0/application-materials/${webConf.others.projectId}`,
      callback(data) {
        let { trainings: list = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        this.form.options.disabled = submissionStage !== 'FILLING'

        list = list.map(item => {
          const { start_date: startDate, end_date: endDate } = item
          if (startDate) {
            item.dates = [startDate, endDate]
          }
          return item
        })
        return list.length ? list : [{}]
      }
    },
    update: {
      action: `/api/enrollment/v1.0/application-materials/${webConf.others.projectId}/put`,
      beforeRequest(data) {
        const trainings = data.map(item => {
          const [startDate, endDate] = item.dates
          item.start_date = startDate
          item.end_date = endDate
          return ['start_date', 'end_date', 'institution_cn', 'course_cn'].reduce((result, key) => {
            result[key] = item[key]
            return result
          }, {})
        })
        return { trainings }
      }
    },
    form: {
      prev: { to: { query: { active: 'application_info', tab: 'application_info_answer' } }, isSubmit: true },
      next: { to: { query: { active: 'application_info', tab: 'application_info_honor' } }, isSubmit: true },
      hasAdd: true,
      options: { labelWidth: '140px' },
      items: [
        {
          type: 'v-datepicker',
          label: '培训时间',
          model: 'dates',
          attrs: {
            type: 'monthrange',
            rangeSeparator: '至',
            startPlaceholder: '请选择开始时间',
            endPlaceholder: '请选择结束时间',
            valueFormat: 'yyyy-MM'
          },
          rules: [{ required: true, message: '请选择培训时间', trigger: 'blur' }]
        },
        {
          type: 'v-input',
          label: '培训机构',
          model: 'institution_cn',
          rules: [{ required: true, message: '请输入培训机构', trigger: 'blur' }]
        },
        {
          type: 'v-input',
          label: '课程名称',
          model: 'course_cn',
          rules: [{ required: true, message: '请输入课程名称', trigger: 'blur' }]
        }
      ]
    }
  }
}
