export default {
  data() {
    return {
      heightdy: '',
      scrollTop: '',
      navigation: false,
      ones: true
    }
  },
  methods: {
    getElementTop(element) {
      if (!element) return

      var actualTop = element.offsetTop
      var current = element.offsetParent

      while (current !== null) {
        actualTop += current.offsetTop
        current = current.offsetParent
      }
      return actualTop
    },
    getHeight() {
      const height = document.documentElement
        ? document.documentElement.clientHeight
        : window.innerHeight
      this.heightdy = height
    },
    watchScroll() {
      this.scrollTop =
        window.pageYOffset ||
        document.documentElement.scrollTop ||
        document.body.scrollTop
      if (this.scrollTop > 0) {
        this.navigation = true
      } else {
        this.navigation = false
      }
      var present = window.innerHeight + this.scrollTop
      var top = this.getElementTop(this.$refs.counter)
      if (present > top + 150 && this.ones) {
        this.ones = false
        if (this.handleScroll) {
          this.handleScroll()
        }
      }
      if (this.dyScroll) {
        this.dyScroll(present, this.scrollTop)
      }
    }
  },
  created() {
    window.addEventListener('resize', this.getHeight)
    this.getHeight()
  },
  mounted() {
    this.watchScroll()
    window.addEventListener('scroll', this.watchScroll, true)
  },
  destroyed() {
    window.removeEventListener('resize', this.getHeight)
    window.removeEventListener('scroll', this.watchScroll)
  }
}
