export default class GlobalVariable {
  /* 初始化函数，传入整个Vue对象 */
  init(Vue, obj) {
    this.setInitSiderbarVar(Vue, obj)
    this.setInitUserInfo(Vue)
  }
  /**
   * 定义siderbar 初始变量
   * 目的：刷新页面时，定位siderbar位置
   */
  setInitSiderbarVar(Vue, obj) {
    let _$ = Vue.prototype.$GlobalVariable
    if (/^\/app\//g.test(obj.to.path)) {
      _$['siderbar'] = {
        defaultPath: (obj && obj.to && obj.to.path) || ''
      }
    }
  }
  /**
   * 定义 UserInfo 初始化用户信息，判断是否登录等
   */
  setInitUserInfo(Vue) {
    let _$ = Vue.prototype.$GlobalVariable
    if (!_$.UserInfo) {
      _$.UserInfo = {}
    }
  }
}
