import BaseAPI from './base_api'

export default class ScoreAPI extends BaseAPI {
  // 获取文章分类
  getAllClassify = (obj = {}) => this.get('/api/microservices/api/category/articles', obj, {})
  // 获取文章
  getArticle = (obj = {}) => this.get('/api/microservices/api/article/list', obj, {})
  // 获取文章详情
  getArticleDetail = (id) => this.get(`/api/microservices/api/article/${id}/info`)
  // formCommit = (data) => this.post('/api/microservices/api/form/commit', data)
  formCommit = (data) => this.post('/api/microservices/api/v3/apply/teacher-form', data)
  // 获取轮播
  getBanner = (obj = {}) => this.get('/api/microservices/api/carousel/list', obj, {})
  // 发送验证码
  sendCheckedCode = (obj = {}) => this.post('/api/usercenter/user/send-code', obj)
  // 注册
  register = (obj = {}) => this.post('/api/usercenter/user/register', obj)
  // 注册
  register2 = (obj = {}) => this.post('/api/usercenter/user/register-and-login-by-mobile', obj)
  // 获取用户信息
  getUserInfo = () => this.get('/api/passport/account/get-user-info')
  // 表单回显
  getFormDetail = () => this.get('/api/microservices/api/v3/apply/teacher-form-detail')
  // 下单
  getOrder = (obj = {}) => this.post('/api/microservices/api/v3/apply/unified-order', obj)
  // 查看订单状态
  checkPay = (id) => this.get(`/api/pay/v1/order/status/${id}`)
  // 支付完成通知
  payEnd = (obj = {}) => this.post('/api/microservices/api/v3/apply/pay-end', obj)
}
