/**
 * 个人信息
 */

export default function(_this) {
  return {
    id: 'application_info_first',
    title: '个人信息',
    required: true,
    visible() {
      return this.tabActive === 'application_info_first'
    },
    get: {
      action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/${window.PROJECT_ID}`,
      callback(data) {
        const { basic_info: basicInfo = {}, attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        this.form.options.disabled = submissionStage !== 'FILLING'

        const attachment = attachments.reduce(
          (result, item) => {
            const types = ['ID_CARD_FRONT', 'ID_CARD_BACK', 'HK_ID_CARD', 'PASSPORT', 'OTHER_ID_CARD_PHOTO', 'DIPLOMA_CN']
            types.forEach(type => {
              if (item.file_type_id === type) {
                result[type].push(item)
              }
            })
            return result
          },
          { ID_CARD_FRONT: [], ID_CARD_BACK: [], HK_ID_CARD: [], PASSPORT: [], OTHER_ID_CARD_PHOTO: [], DIPLOMA_CN: [] }
        )
        basicInfo.id_type = basicInfo.id_type === '护照' ? '中国护照' : basicInfo.id_type
        return Object.assign({}, basicInfo, attachment)
      }
    },
    update: {
      action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/${window.PROJECT_ID}/put`,
      beforeRequest(data) {
        const basicInfo = ['phone_number', 'email', 'id_type'].reduce((result, key) => {
          result[key] = data[key]
          return result
        }, {})
        return { basic_info: basicInfo }
      }
    },
    form: {
      hasButton: false,
      next: { to: { query: { active: 'application_info', tab: 'application_info_profile' } }, isSubmit: true },
      options: { labelWidth: '140px' },
      items: [
        {
          type: 'v-input',
          label: '手机号',
          model: 'phone_number',
          attrs: { placeholder: '请输入手机号', maxlength: 11 },
          rules: [{ required: true, pattern: /^1[3-9]\d{9}$/, message: '请输入手机号', trigger: 'blur' }]
        },
        {
          type: 'v-input',
          label: '邮箱',
          model: 'email',
          attrs: { placeholder: '请输入邮箱' },
          rules: [{ type: 'email', required: true, message: '请输入邮箱', trigger: 'blur' }]
        },
        {
          type: 'v-select',
          values: [{ value: '居民身份证' }, { value: '港澳台身份证' }, { value: '中国护照' }, { value: '其他' }],
          label: '证件类型',
          model: 'id_type',
          attrs: { placeholder: '请选择证件类型' },
          rules: [{ required: true, message: '请选择证件类型', trigger: 'change' }]
        },
        // 身份证照片(背面)
        {
          type: 'v-upload',
          label: '身份证人像面',
          model: 'ID_CARD_BACK',
          attrs: {
            action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${window.PROJECT_ID}/put`,
            deleteAction: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${window.PROJECT_ID}/delete`,
            data: { file_type: 'ID_CARD_BACK' },
            limit: 1,
            accept: 'image/*',
            image: 'https://zws-imgs-pub.ezijing.com/pc/cu/id_card_back.png'
          },
          rules: [{ type: 'array', required: true, message: '请上传身份证照片人像面', trigger: 'change' }],
          isShow(data) {
            return data.id_type === '居民身份证'
          }
        },
        // 身份证照片(正面）
        {
          type: 'v-upload',
          label: '身份证国徽面',
          model: 'ID_CARD_FRONT',
          attrs: {
            action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${window.PROJECT_ID}/put`,
            deleteAction: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${window.PROJECT_ID}/delete`,
            data: { file_type: 'ID_CARD_FRONT' },
            limit: 1,
            accept: 'image/*',
            image: 'https://zws-imgs-pub.ezijing.com/pc/cu/id_card_front.png'
          },
          rules: [{ type: 'array', required: true, message: '请上传身份证照片国徽面', trigger: 'change' }],
          isShow(data) {
            return data.id_type === '居民身份证'
          }
        },
        // 港澳台身份证
        {
          type: 'v-upload',
          label: '港澳台身份证',
          model: 'HK_ID_CARD',
          attrs: {
            action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${window.PROJECT_ID}/put`,
            deleteAction: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${window.PROJECT_ID}/delete`,
            data: { file_type: 'HK_ID_CARD' },
            limit: 1,
            accept: 'image/*'
          },
          rules: [{ type: 'array', required: true, message: '请上传港澳台身份证', trigger: 'change' }],
          isShow(data) {
            return data.id_type === '港澳台身份证'
          }
        },
        // 中国护照
        {
          type: 'v-upload',
          label: '中国护照',
          model: 'PASSPORT',
          attrs: {
            action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${window.PROJECT_ID}/put`,
            deleteAction: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${window.PROJECT_ID}/delete`,
            data: { file_type: 'PASSPORT' },
            limit: 1,
            accept: 'image/*'
          },
          rules: [{ type: 'array', required: true, message: '请上传中国护照', trigger: 'change' }],
          isShow(data) {
            return data.id_type === '中国护照'
          }
        },
        // 其他证件
        {
          type: 'v-upload',
          label: '其他证件',
          model: 'OTHER_ID_CARD_PHOTO',
          attrs: {
            action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${window.PROJECT_ID}/put`,
            deleteAction: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${window.PROJECT_ID}/delete`,
            data: { file_type: 'OTHER_ID_CARD_PHOTO' },
            limit: 1,
            accept: 'image/*'
          },
          rules: [{ type: 'array', required: true, message: '请上传其他证件', trigger: 'change' }],
          isShow(data) {
            return data.id_type === '其他'
          }
        },
        // 毕业证书
        {
          type: 'v-upload',
          label: '毕业证书',
          model: 'DIPLOMA_CN',
          attrs: {
            action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${window.PROJECT_ID}/put`,
            deleteAction: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${window.PROJECT_ID}/delete`,
            data: { file_type: 'DIPLOMA_CN' },
            limit: 1,
            accept: 'image/*'
          },
          rules: [{ type: 'array', required: true, message: '请上传毕业证书', trigger: 'change' }]
        }
      ]
    }
  }
}
