/**
 * 推荐信
 */

export default function(_this) {
  return {
    id: 'interview_tjx',
    title: '推荐信',
    get: {
      action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/${window.PROJECT_ID}`,
      callback(data) {
        const { submission_stage: submissionStage = 'FILLING', reco_letters: list = [], attachments = [] } = data.data.material
        const stageList = ['FILLING', 'PREPAYMENT', 'INTERVIEW_APPLICATION', 'AUDITION', 'INTERVIEW', 'PAYMENT', 'REGISTRATION', 'CLOSED']
        this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 2
        const attachment = attachments.reduce(
          (result, item) => {
            const types = ['RECOMMENDATION_LETTER', 'RECOMMENDATION_LETTER_2']
            types.forEach(type => {
              item.disabled = item.upload_operator_user_id !== _this.user.id
              if (item.file_type_id === type) {
                result.RECOMMENDATION_LETTER.push(item)
              }
            })
            return result
          },
          { RECOMMENDATION_LETTER: [] }
        )
        // this.form.options.disabled = list.length >= 2
        return list.length ? list.map(item => Object.assign({}, item, attachment)) : [{ ...attachment }, { ...attachment }]
      }
    },
    update: {
      action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/${window.PROJECT_ID}/put`,
      beforeRequest(data) {
        const [first = {}] = data
        if (first.RECOMMENDATION_LETTER && first.RECOMMENDATION_LETTER.length) {
          return {}
        }
        const letters = data.map(item => {
          delete item.RECOMMENDATION_LETTER
          return item
        })
        return { reco_letters: letters }
      },
      callback({ message }) {
        // this.form.options.disabled = true
        const letters = _this.detail.material.reco_letters || []
        if (!letters.length) {
          _this.sendToProviders()
          _this.getApplication()
        } else {
          this.$message({ type: 'success', message })
        }
      }
    },
    form: {
      minlength: 2,
      // prev: { to: { query: { active: 'interview_byzs' } }, isSubmit: true },
      next: { to: { query: { active: 'interview_cjd' } }, isSubmit: true },
      // hasAdd: true,
      options: { disabled: false, labelWidth: '140px' },
      hint: '<p style="color:#999">以下内容可选其一，填写两个推荐人的信息或者上传两张推荐信照片。</p>',
      disabled(data) {
        return !!data.letter_content
      },
      aside: {
        prepend: {
          html: '<p style="color:#33C011;">推荐人已完成</p>',
          visible(data) {
            return !!data.letter_content
          }
        },
        buttons: [
          {
            text: '再次邀请',
            visible(data) {
              const editable = ['PREPAYMENT', 'REGISTRATION'].includes(_this.detail.material.submission_stage)
              return data.id && !data.letter_content && editable
            },
            onClick(data) {
              _this.sendToProvider(data)
            }
          },
          {
            text: '更换推荐人',
            visible(data) {
              const editable = ['PREPAYMENT', 'REGISTRATION'].includes(_this.detail.material.submission_stage)
              return data.id && !data.letter_content && editable
            },
            onClick(data, $form) {
              $form.validate().then(() => {
                _this.changeProvider(data)
              })
            }
          }
        ]
      },
      items: [
        {
          type: 'v-input',
          label: '推荐人姓名',
          model: 'provider_name',
          attrs: { placeholder: '请输入推荐人姓名' }
          // rules: [{ message: '请输入推荐人姓名', trigger: 'blur' }]
        },
        {
          type: 'v-input',
          label: '推荐人电话',
          model: 'provider_phone_number',
          attrs: { placeholder: '请输入推荐人电话', maxlength: 11 },
          rules: [{ pattern: /^1[3-9]\d{9}$/, message: '请输入推荐人电话', trigger: 'change' }]
        },
        {
          type: 'v-input',
          label: '推荐人邮箱',
          model: 'provider_email',
          attrs: { placeholder: '请输入推荐人邮箱' },
          rules: [{ type: 'email', message: '请输入推荐人邮箱', trigger: 'change' }]
        },
        {
          type: 'v-select',
          values: [{ value: '老师/导师' }, { value: '领导' }, { value: '同学' }, { value: '同事' }, { value: '亲属' }, { value: '朋友' }, { value: '其他' }],
          label: '与推荐人关系',
          model: 'provider_relationship',
          rules: [{ message: '请选择与推荐人关系', trigger: 'change' }]
        }
      ],
      appendItems: [
        // 推荐信附件
        {
          type: 'v-upload',
          label: '附件上传',
          model: 'RECOMMENDATION_LETTER',
          attrs: {
            action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${window.PROJECT_ID}/put`,
            deleteAction: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${window.PROJECT_ID}/delete`,
            data: { file_type: 'RECOMMENDATION_LETTER' },
            accept: 'image/*'
          },
          // rules: [{ type: 'array', required: true, message: '请上传推荐信附件', trigger: 'change' }],
          append: '请上传推荐人署名的推荐信原件照片或扫描件 ',
          class: 'upload-letter'
        }
      ]
    }
  }
}
