export default function(_this) {
  return {
    id: 'admission_xy',
    title: '入学协议',
    get: {
      action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/${webConf.others.projectId}`,
      callback(data) {
        const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        const stageList = [
          'FILLING',
          'PREPAYMENT',
          'INTERVIEW_APPLICATION',
          'AUDITION',
          'INTERVIEW',
          'PAYMENT',
          'REGISTRATION',
          'CLOSED'
        ]
        this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 6
        const ADMISSION_AGREEMENT = attachments.filter(item => {
          return item.file_type_id === 'ADMISSION_AGREEMENT'
        })
        return { ADMISSION_AGREEMENT }
      }
    },
    form: {
      next: { to: { query: { active: 'admission_xfjn' } } },
      hasButton: false,
      options: {},
      items: [
        {
          type: 'v-upload',
          required: true,
          model: 'ADMISSION_AGREEMENT',
          attrs: {
            action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/put`,
            deleteAction: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/delete`,
            data: { file_type: 'ADMISSION_AGREEMENT' }
          },
          // prepend: `
          // <p>第一步：点击下载按键获取入学协议</p>
          // <p><a href="https://zws-imgs-pub.ezijing.com/pc/cu/%E5%85%A5%E5%AD%A6%E5%8D%8F%E8%AE%AE2%EF%BC%88%E8%AF%B7%E4%B8%8B%E8%BD%BD%E6%A8%A1%E6%9D%BF%E5%A1%AB%E5%86%99%E5%90%8E%E4%B8%8A%E4%BC%A0%E7%85%A7%E7%89%87%EF%BC%89.docx" target="_blank" download>下载入学协议</a></p>
          // <p>第二步：申请者可将签字后的入学协议原件扫描或拍照后提交。学员应仔细阅读《入学协议》以及课程介绍，如对入学协议或课程有异议，请第一时间与课程顾问咨询确认。请用A4纸打印后，在入学协议上签上姓名和日期，内容需显示完整、格式整齐、字迹清晰可辨。点击下方按钮，上传文件</p>
          // `
          prepend: `
            <p>第一步：请以录取通知书的协议为准</p>
            <p>第二步：申请者可将签字后的入学协议原件扫描或拍照后提交。学员应仔细阅读《入学协议》以及课程介绍，如对入学协议或课程有异议，请第一时间与课程顾问咨询确认。请用A4纸打印后，在入学协议上签上姓名和日期，内容需显示完整、格式整齐、字迹清晰可辨。点击下方按钮，上传文件</p>
          `
        }
      ]
    }
  }
}
