import md5 from 'blueimp-md5'
import { getSignature, uploadFile } from '@/api/base'

export async function upload(blob) {
  const key = 'upload/eec/' + md5(new Date().getTime() + Math.random().toString(36).slice(-8)) + '.png'
  const response = await getSignature()
  const params = {
    key,
    host: response.host,
    OSSAccessKeyId: response.accessid,
    policy: response.policy,
    signature: response.signature,
    success_action_status: '200',
    file: blob,
    url: `${response.host}/${key}`,
  }
  await uploadFile(params)
  return params.url
}
