export default {
  id: 'interview_am',
  title: 'AMI/AMS 3-6主教证书',
  get: {
    action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/${webConf.others.projectId}`,
    callback(data) {
      const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
      const stageList = [
        'FILLING',
        'PREPAYMENT',
        'INTERVIEW_APPLICATION',
        'AUDITION',
        'INTERVIEW',
        'PAYMENT',
        'REGISTRATION',
        'CLOSED'
      ]
      this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 2
      const AMI_AMS_3_6 = attachments.filter(item => {
        return item.file_type_id === 'AMI_AMS_3_6'
      })
      return { AMI_AMS_3_6 }
    }
  },
  form: {
    prev: { to: { query: { active: 'interview_byz' } } },
    next: { to: { query: { active: 'interview_cjd' } } },
    hasButton: false,
    options: {},
    items: [
      {
        type: 'v-upload',
        required: true,
        model: 'AMI_AMS_3_6',
        attrs: {
          action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/put`,
          deleteAction: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/delete`,
          data: { file_type: 'AMI_AMS_3_6' }
        },
        append: '注意事项：需要将证书原件扫描或拍照后提交，请确保证书内容清晰可辨。'
      }
    ]
  }
}
