import BaseAPI from './base_api'

export default class ScoreAPI extends BaseAPI {
  // 获取文章分类
  getAllClassify = (obj = {}) => this.get('/api/microservices/api/category/articles', obj, {})
  // 获取文章
  getArticle = (obj = {}) => this.get('/api/microservices/api/article/list', obj, {})
  // 获取文章详情
  getArticleDetail = (id) => this.get(`/api/microservices/api/article/${id}/info`)
  // formCommit = (data) => this.post('/api/microservices/api/form/commit', data)
  formCommit = (data) => this.post('/api/microservices/api/apply/teacher-form', data)
  // 获取轮播
  getBanner = (obj = {}) => this.get('/api/microservices/api/carousel/list', obj, {})
  // 发送验证码
  sendCheckedCode = (obj = {}) => this.post('/api/usercenter/user/send-code', obj)
  // 注册
  register = (obj = {}) => this.post('/api/usercenter/user/register', obj)
}
