export default {
  id: 'interview_cjd',
  title: '成绩单（中+英）',
  get: {
    action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/${webConf.others.projectId}`,
    callback(data) {
      const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
      const stageList = [
        'FILLING',
        'PREPAYMENT',
        'INTERVIEW_APPLICATION',
        'AUDITION',
        'INTERVIEW',
        'PAYMENT',
        'REGISTRATION',
        'CLOSED'
      ]
      this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 2
      return attachments.reduce(
        (result, item) => {
          if (item.file_type_id === 'REPORT_CARD_CN') {
            result.REPORT_CARD_CN.push(item)
          }
          if (item.file_type_id === 'REPORT_CARD_EN') {
            result.REPORT_CARD_EN.push(item)
          }
          return result
        },
        { REPORT_CARD_CN: [], REPORT_CARD_EN: [] }
      )
    }
  },
  form: {
    prev: { to: { query: { active: 'interview_byz' } } },
    next: { to: { query: { active: 'interview_zp' } } },
    hasButton: false,
    options: { 'label-position': 'top' },
    hint: `
      <p>成绩单：中英文成绩单各上传一个文件</p>
      <p>注意事项：需要将证书原件扫描或拍照后提交，请确保证书内容清晰可辨。</p>
      <p>* 中文成绩单：须学校开具的正式成绩单或档案馆调取的成绩单复印件方为有效，且必须盖有公章（例如教务处公章、档案处成绩公章等）。</p>
      <p>* 英文成绩单：内容和格式必须与中文成绩单保持一致，并盖有翻译公章（推荐去淘宝找具有资质和翻译公章的翻译公司进行翻译）。英文成绩单可不盖学校公章。</p>
    `,
    items: [
      {
        type: 'v-upload',
        label: '中文成绩单',
        required: true,
        model: 'REPORT_CARD_CN',
        attrs: {
          action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/put`,
          deleteAction: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/delete`,
          data: { file_type: 'REPORT_CARD_CN' }
        }
      },
      {
        type: 'v-upload',
        label: '英文成绩单',
        required: true,
        model: 'REPORT_CARD_EN',
        attrs: {
          action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/put`,
          deleteAction: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/delete`,
          data: { file_type: 'REPORT_CARD_EN' }
        }
      }
    ]
  }
}
