import Layout from '@/layout/index.vue'
export const constantRoutes = [
  {
    path: '/redirect',
    component: Layout,
    hidden: true,
    children: [
      {
        path: '/redirect/:path(.*)',
        component: () => import('@/pages/redirect/index.vue')
      }
    ]
  },
  {
    path: '/',
    component: Layout,
    redirect: '/home-page',
    children: [
      {
        path: 'home-page',
        component: () => import('@/pages/homepage/index.vue'),
        meta: {
          title: '首页'
        },
        name: 'home-page'
      }
    ]
  },
  {
    path: '/major-set',
    component: Layout,
    children: [
      {
        path: 'index',
        component: () => import('@/pages/major-set/index.vue'),
        meta: {
          title: '专业设置'
        },
        name: 'major-set'
      }
    ]
  },
  {
    path: '/apply',
    component: Layout,
    children: [
      {
        path: 'for',
        component: () => import('@/pages/apply-for/index.vue'),
        meta: {
          details: true,
          title: '报名申请'
        },
        name: 'apply-for'
      },
      {
        path: 'for/register',
        hidden: true,
        component: () => import('@/pages/register/index.vue'),
        meta: {
          title: '注册',
          details: true
        },
        name: 'register'
      },
      {
        path: 'for/forgetPsw',
        hidden: true,
        component: () => import('@/pages/forgetPsw/index.vue'),
        meta: {
          title: '忘记密码',
          details: true
        },
        name: 'forgetPsw'
      },
      {
        path: 'for/apply',
        hidden: true,
        component: () => import('@/pages/apply/index.vue'),
        meta: {
          title: '在线报名',
          details: true,
          userRole: true
        },
        name: 'apply'
      },
      {
        path: 'for/login',
        hidden: true,
        component: () => import('@/pages/login/index.vue'),
        meta: {
          title: '登录',
          details: true
        },
        name: 'login'
      }
    ]
  },
  {
    path: '/recent',
    component: Layout,
    children: [
      {
        path: 'news',
        component: () => import('@/pages/recent-news/index.vue'),
        meta: {
          title: '最新动态'
        },
        name: 'recent-news'
      },
      {
        path: 'news/:id',
        meta: {
          title: '最新动态',
          details: true
        },
        hidden: true,
        name: 'details-recent-news',
        component: () => import('@/pages/details-news/index.vue')
      }
    ]
  },
  {
    path: '/contact',
    component: Layout,
    children: [
      {
        path: 'us',
        component: () => import('@/pages/contact-us/index.vue'),
        meta: {
          title: '联系我们'
        },
        name: 'contact-us'
      }
    ]
  }

  // { path: '*', redirect: '/404', hidden: true }
]
export default {
  constantRoutes
}
