const path = require('path')
const webpack = require('webpack')
const WebpackMerge = require('webpack-merge')

const _conf = require('./config')

const $GLOBAL = {
  isDev: _conf.isDev,
  ResDir: _conf.ResDir,
  'isEnableToIphoneDebugger': _conf.isEnableToIphoneDebugger,

  templatePath: path.resolve(__dirname, '../' + _conf.HtmlPath),
  icoPath: _conf.IcoPath,

  EntryPath: path.resolve(__dirname, '../' + _conf.JsPath),
  OutputPath: path.resolve(__dirname, '../' + _conf.DesDir),

  jsName: 'resources/[name].[chunkhash:8].js',
  cssName: 'resources/[name].[contenthash:12].css',
  resName: 'resources/[name].[hash:8].[ext]',

  EntryStaticPath: path.resolve(__dirname, '../' + 'static'),
  OutputStaticPath: path.resolve(__dirname, '../' + _conf.DesDir + '/static'),

  webConf: {
    'isDev': _conf.isDev,
    'serverPort': process.env.SERVER_PORT || 8000,
    'isEnableToIphoneDebugger': _conf.isEnableToIphoneDebugger,
    'domain': _conf.domain,
    'url': _conf.url,
    'isHttps': _conf.isHttps,
    'apiBaseURL': _conf.apiBaseURL || '/api',
    'CDN_PATH': _conf.CDN_BASE + _conf.CDN_DIR,
    'others': _conf.others || {}
  },
  externals: _conf.webpack.externals || {},
  ProvidePlugin: _conf.webpack.ProvidePlugin || {},
  BaseConfig: {}
}

$GLOBAL.BaseConfig = {
  target: 'web',
  entry: $GLOBAL.EntryPath,
  output: {
    filename: $GLOBAL.jsName,
    path: $GLOBAL.OutputPath,
    publicPath: $GLOBAL.isDev === 'development' ? '/' : $GLOBAL.webConf.CDN_PATH
  },
  resolve: {
    alias: {
      '@': path.resolve(__dirname, '../' + $GLOBAL.ResDir),
      '@api': path.resolve(__dirname, '../' + $GLOBAL.ResDir + '/api'),
      '@action': path.resolve(__dirname, '../' + $GLOBAL.ResDir + '/action'),
      '@tool': path.resolve(__dirname, '../' + $GLOBAL.ResDir + '/tool')
    }
  },
  module: {
    rules: [
      {
        test: /\.(vue|js|jsx)$/,
        loader: 'eslint-loader',
        exclude: /node_modules/,
        enforce: 'pre'
      },
      {
        test: /\.vue$/,
        loader: 'vue-loader'
      },
      {
        test: /(\.jsx|\.js)$/,
        exclude: /(node_modules)|(dist)/,
        loader: 'babel-loader',
        options: {
          presets: ['env', 'stage-2'],
          plugins: [
            'transform-vue-jsx',
            'syntax-dynamic-import'
          ]
        }
      },
      {
        test: /\.(png|jpe?g|gif|svg|ico)(\?.*)?$/,
        use: {
          loader: 'url-loader',
          options: {
            esModule: false,
            limit: 4096,
            name: $GLOBAL.resName
          }
        }
      },
      {
        test: /\.(mp4|webm|ogg|mp3|wav|flac|aac)(\?.*)?$/,
        loader: 'url-loader',
        options: {
          limit: 10000,
          name: $GLOBAL.resName
        }
      },
      {
        test: /\.(woff2?|eot|ttf|otf)(\?.*)?$/,
        loader: 'url-loader',
        options: {
          limit: 10000,
          name: $GLOBAL.resName
        }
      }
    ]
  },
  externals: {
  },
  plugins: [
    new webpack.DefinePlugin({
      'webConf': JSON.stringify($GLOBAL.webConf)
    }),
    new webpack.ProvidePlugin($GLOBAL.ProvidePlugin)
  ]
}
$GLOBAL.BaseConfig = WebpackMerge($GLOBAL.BaseConfig, _conf.webpack)

module.exports = $GLOBAL
