export default {
  id: 'interview_byzs',
  title: '毕业证书',
  get: {
    action: `/api/enrollment/v1.0/application-materials/${webConf.others.projectId}`,
    callback(data) {
      const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
      const stageList = [
        'FILLING',
        'PREPAYMENT',
        'INTERVIEW_APPLICATION',
        'AUDITION',
        'INTERVIEW',
        'PAYMENT',
        'REGISTRATION',
        'CLOSED'
      ]
      this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 2
      const DIPLOMA_CN = attachments.filter(item => {
        return item.file_type_id === 'DIPLOMA_CN'
      })
      return { DIPLOMA_CN }
    }
  },
  form: {
    next: { to: { query: { active: 'interview_xwzs' } } },
    hasButton: false,
    options: {},
    items: [
      {
        type: 'v-upload',
        required: true,
        model: 'DIPLOMA_CN',
        attrs: {
          action: `/api/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/put`,
          deleteAction: `/api/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/delete`,
          data: { file_type: 'DIPLOMA_CN' }
        },
        append:
          '申请者需要将本科或以上毕业证书原件扫描或者拍照后提交。<br> 可上传多个文件，请确保证书号码清晰可辨。<br> 上传文件仅限“jpg,jpeg,png”格式，文件小于10MB。'
      }
    ]
  }
}
