export default {
  id: 'interview_xwzs',
  title: '学位证书',
  get: {
    action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/${webConf.others.projectId}`,
    callback(data) {
      const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
      const stageList = [
        'FILLING',
        'PREPAYMENT',
        'INTERVIEW_APPLICATION',
        'AUDITION',
        'INTERVIEW',
        'PAYMENT',
        'REGISTRATION',
        'CLOSED'
      ]
      this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 2
      const DEGREE_CERT_CN = attachments.filter(item => {
        return item.file_type_id === 'DEGREE_CERT_CN'
      })
      return { DEGREE_CERT_CN }
    }
  },
  form: {
    prev: { to: { query: { active: 'interview_byzs' } } },
    next: { to: { query: { active: 'interview_ywjl' } } },
    hasButton: false,
    options: {},
    items: [
      {
        type: 'v-upload',
        required: true,
        model: 'DEGREE_CERT_CN',
        attrs: {
          action: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/put`,
          deleteAction: `${webConf.apiBaseURL}/enrollment/v1.0/application-materials/attachments/${webConf.others.projectId}/delete`,
          data: { file_type: 'DEGREE_CERT_CN' }
        },
        append:
          '申请者需要将学位证书原件扫描或者拍照后提交。<br>可上传多个文件，请确保证书号码清晰可辨。<br>上传文件仅限“jpg,jpeg,png”格式，文件小于10MB。'
      }
    ]
  }
}
