import BaseAPI from './base_api'

export default class ScoreAPI extends BaseAPI {
  // 获取文章分类
  getAllClassify = (obj = {}) => this.get('/microservices/api/category/articles', obj, {})
  // 获取文章
  getArticle = (obj = {}) => this.get('/microservices/api/article/list', obj, {})
  // 获取文章详情
  getArticleDetail = (id) => this.get(`/microservices/api/article/${id}/info`)
  formCommit = (data) => this.post('/microservices/api/form/commit', data)
  // 获取轮播
  getBanner = (obj = {}) => this.get('/microservices/api/carousel/list', obj, {})
}
