export default function(_this) {
  return {
    required: true,
    id: 'interview_cjd',
    title: '成绩单',
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}`,
      callback(data) {
        const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        const stageList = [
          'FILLING',
          'PREPAYMENT',
          'INTERVIEW_APPLICATION',
          'AUDITION',
          'INTERVIEW',
          'PAYMENT',
          'REGISTRATION',
          'CLOSED'
        ]
        this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 2
        return attachments.reduce(
          (result, item) => {
            if (item.file_type_id === 'REPORT_CARD_CN') {
              result.REPORT_CARD_CN.push(item)
            }
            if (item.file_type_id === 'REPORT_CARD_EN') {
              result.REPORT_CARD_EN.push(item)
            }
            return result
          },
          { REPORT_CARD_CN: [], REPORT_CARD_EN: [] }
        )
      }
    },
    form: {
      prev: { to: { query: { active: 'interview_ywjl' } } },
      next: { to: { query: { active: 'interview_yynl' } } },
      hasButton: false,
      options: { 'label-position': 'top' },
      hint: `
      <p>已毕业学生需提交完整成绩单，未毕业学生提交现有成绩单，成绩单需要加盖学校公章</p>
      <p>请将中文成绩单原件扫描或者拍照后提交。</p>
      <p>获取途径:联系大学时就读学校相关部门(档案馆/教务处)获取成绩单。</p>
    `,
      items: [
        {
          required: true,
          type: 'v-upload',
          label: '中文成绩单',
          model: 'REPORT_CARD_CN',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'REPORT_CARD_CN' }
          }
        }
        // {
        //   type: 'v-upload',
        //   label: '英文成绩单',
        //   model: 'REPORT_CARD_EN',
        //   attrs: {
        //     action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
        //     deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
        //     data: { file_type: 'REPORT_CARD_EN' }
        //   }
        // }
      ]
    }
  }
}
