import path from 'path'
import fs from 'fs'
import routes from './router/routes'

export default {
  ssr: false,
  env: process.env,
  server: { port: 2048, host: '0.0.0.0' },
  ...(process.env.NODE_ENV === 'development' && {
    server: {
      host: 'dev.ezijing.com',
      https: {
        key: fs.readFileSync(path.resolve(__dirname, 'dev.ezijing.com-key.pem')),
        cert: fs.readFileSync(path.resolve(__dirname, 'dev.ezijing.com.pem')),
      },
    },
  }),
  // Global page headers: https://go.nuxtjs.dev/config-head
  head: {
    title: '斯蒂文斯理工学院硕士保研项目',
    htmlAttrs: {
      lang: 'en',
    },
    meta: [
      { charset: 'utf-8' },
      { hid: 'viewport', name: 'viewport', content: 'width=device-width, initial-scale=1' },
      {
        name: 'keywords',
        content: '国际留学,美国留学,留学，预科留学，硕士留学，留学保研项目',
      },
      {
        name: 'description',
        content:
          '斯蒂文斯理工学院创办于1870年，和麻省理工、加州理工、伦斯勒理工学院并称为美国四大理工学院，是美国历史最为悠久的理工学院之一。斯蒂文斯理工学院是一所在美国的教育和研究领域中位居前沿的理工类大学，长年位列U.S. News & World Report全美Top100。斯蒂文斯理工学院下设四大学院，提供35个本科、58个硕士及20个博士学位专业。',
      },
    ],
    link: [
      {
        rel: 'icon',
        type: 'image/x-icon',
        href: 'https://zws-imgs-pub.ezijing.com/static/public/f56441ae1441902080226712d4d650aa.ico',
      },
    ],
  },
  // Global CSS: https://go.nuxtjs.dev/config-css
  css: ['vant/lib/index.css', '@ezijing/vue-form/style.css', 'assets/theme/index.css', 'assets/css/base.css'],

  // Plugins to run before rendering page: https://go.nuxtjs.dev/config-plugins
  plugins: [
    '@/plugins/vant',
    '@/plugins/i18n',
    '@/plugins/router',
    '@/plugins/axios',
    '@/plugins/element-ui',
    {
      // 引入一个插件，这里的 ssr 表示使用服务端渲染
      src: 'plugins/vue-swiper.js',
      ssr: false,
    },
  ],

  // Auto import components: https://go.nuxtjs.dev/config-components
  components: true,

  // Modules for dev and build (recommended): https://go.nuxtjs.dev/config-modules
  buildModules: [],

  // Modules: https://go.nuxtjs.dev/config-modules
  modules: ['cookie-universal-nuxt'],

  // Build Configuration: https://go.nuxtjs.dev/config-build
  build: {
    transpile: [/^element-ui/],
  },
  router: {
    extendRoutes: routes,
    middleware: ['device', 'i18n'],
  },
}
